#include <absacc.h>
#include <reg51.h>

#define         uchar           unsigned char
#define 	uint		unsigned int
#define		LedPort		XBYTE[0xC000]
#define		SwitchPort	XBYTE[0xC800]

bit		fscf,crcf,tsn,rsn,tfs,rfs,wxyf,jscf,stno,secflg;
bit		mute,sound,fireflag,startflag,faultflag,negs;
uchar data	crc1,crc2,cfcs,dest,netno,
		b2btime,wxycount,sectimer,bcount;

uchar data	keynum,keyfirst,imgcode;

uint  data	rpt,spt,tpt,onlpt,onlrpt,rrpt;

uchar data	month,day,hour,min,sec;

uchar xdata	firenum=0,firefirst=0,firecur=0,faultnum=0,faultfirst=0,faultcur=0,startnum=0,startfirst=0,startcur=0 ;

sbit		WDT	= P1^6;			/*WDTλߡ*/
sbit		DRV485  = P1^4;			/*485н */
sbit		SpCtr	= P1^5;
sbit		BkLCtr  = P1^7;

/*uchar xdata	TrBuf[0x400];*/			/*ͻ1kԪ*/
/*uchar xdata	ReBuf[0x400];*/			/*ջ32Ԫ  */
uchar xdata 	KeyBuf[0x10];			/*ֵ16Ԫ  */
uchar xdata	Fire[256][32];
uchar xdata	Fault[256][32];
uchar xdata	Start[256][32];

extern uchar data zkpb;

extern void	RS485(void);			/*485ջӳ*/
/*extern void 	SW485(uchar,uchar);*/		/*ͻװϢ֡*/
extern void	SIOT(void);			/*UARTжϴӳ*/
extern void	Delay(uchar);			/*ʱӳ*/
extern void	Clear(void);
extern void     IntLcd(void);
extern void	OutEvent(uchar xdata *);
extern void 	DispNoEvent(uchar);
extern void 	ShowStartImg(void);
extern void	OutTNum(uchar,uchar);
extern void	OutCur(uchar);
extern void	INTLCD();
extern void     CLEAR();

void		KeyProc(void);
void		OutSec(void);
void		SelfTest(void);
void		DispEvent(uchar,uchar);

void  sint(void) interrupt 4 using 0		/*пжϳΪ*/
{
	WDT = ~WDT;
	SIOT();
	WDT = ~WDT;
}

void  intx0(void) interrupt 0 using 3
{
	uchar tmpkey,i,j;
	tmpkey = P1 & 0x0F;
	Delay(50);
	if(tmpkey == ( P1 & 0xF ))
	{
		tmpkey = ~tmpkey;
		for(i = 0,j = 1;i<4;i++)
		{
			if((j&tmpkey) == j)
			{
				if(keynum <0x10)
				{
					keynum += 1;
					KeyBuf[ (keyfirst + keynum) & 0x0F ] = i;
				}
				else
				{
					KeyBuf[keyfirst] = i;
					keyfirst = ( keyfirst +1 ) & 0x0F;
				}
			}
			break;
		}
	}
}


void  intt0(void) interrupt 1 using 3		/*50msжϴӳжĴ飳*/
{
	TH0 = 0x87;
	TL0 = 0xFF;

	sectimer += 1;
	if(sectimer == 20) { sectimer = 0; sec = (sec + 1) % 60 ; secflg = 1;}

	if( wxycount != 0 )			/*wxycountÿжһμΪʱӦ־λwxyf*/
	  {
	  	wxycount = wxycount - 1;
	  	if( wxycount == 0 ) wxyf = 1;
	  }
	if( b2btime != 0 )			/*b2bcountÿжһμΪʱýմ־λjscf*/
	  {
	  	b2btime = b2btime - 1;
	  	if ( b2btime == 0 ) jscf = 1;
	  }
}


void main(void)
{

	PCON = 0x0;
	SCON = 0xF0;
	TMOD = 0x21;
	TH0 = 0xFB;
	TL0 = 0x32;
	SM2 = 1;
	netno = ( SwitchPort & 0x3F ) + 73;		/*뿪ݵͣλ73Ϊ*/
	stno = 1;
	WDT = ~WDT;

	if((SwitchPort & 0x80) == 0x80) { TH1 = TL1 = 0xFE; }	/*뿪ݵλΪ0ʱbaud = 4800bpsΪ1ʱbaud = 9600bps*/
 	else { TH1 = TL1 = 0xFC; }

	SelfTest();
 	ET0 = 1;
 	TR0 = 1;
 	ES  = 1;
 	PS  = 1;
 	TR1 = 1;
 	EA = 1;
 	DRV485 = 0;
 	BkLCtr = 1;

        INTLCD();
        CLEAR();
 	ShowStartImg();

 	while (1)
 	{
 		if(keynum !=0) 	KeyProc();
 		if(secflg == 1)	{ OutSec(); secflg = 0;}
                /*if(rpt != rrpt)*/ RS485();
                if(fireflag == 1) {imgcode = 1; DispEvent( 0x01,firefirst + firecur ); fireflag = 0;}
                if(startflag == 1) {imgcode = 2; DispEvent( 0x02,startfirst + startcur ); startflag = 0;}
                if(faultflag == 1) {imgcode = 3; DispEvent( 0x03,faultfirst + faultcur ); faultflag = 0;}
        }
}


void SelfTest(void)
{
	uchar i;
	zkpb = 	LedPort;
	LedPort = LedPort | 0x0f;
	for(i = 0;i<100;i++);
	LedPort = zkpb;
}

void KeyProc(void)
{
	switch(KeyBuf[keyfirst])
	{
		case 0x00:
		{
			switch(imgcode)
			{
				case 0x00 : break;
				case 0x01 :
				{

					if(firecur > 0) firecur -= 1;
					DispEvent( 0x01,firefirst + firecur );
					break;
				}
				case 0x02 :
				{
					if(startcur >0) startcur -= 1;
					DispEvent( 0x02,startfirst + startcur );
					break;
				}
				case 0x03 :
				{
					if(faultcur >0) faultcur -= 1;
					DispEvent( 0x03,faultfirst + faultcur );
					break;
				}
				case 0x04 : break;
				default   : break;
			}
		}
		case 0x01:
		{
			switch(imgcode)
			{
				case 0x00 : break;
				case 0x01 :
				{
					if(firecur < (firenum - 1 )) firecur += 1;
					DispEvent( 0x01,firefirst + firecur );
					break;
				}
				case 0x02 :
				{
					if(startcur < (startnum - 1)) startcur += 1;
					DispEvent( 0x02,startfirst + startcur );
					break;
				}
				case 0x03 :
				{
					if(faultcur < (faultnum - 1)) faultcur += 1;
					DispEvent( 0x03,faultfirst + faultcur );
					break;
				}
				case 0x04 : break;
				default   : break;
			}
		}
		case 0x02:
		{
			if(imgcode != 0) imgcode = ( imgcode & 0x03 ) + 1 ;
			else break;

                        switch(imgcode)
			{
				case 0x01 :
				{
					if(firenum > 0)
					{
						DispEvent( 0x01,firefirst + firenum - 1 );
					        break;
					}
					else DispNoEvent( 0x01 );
					break;
				}
				case 0x02 :
				{
					if( startnum > 0)
					{
						DispEvent( 0x02,startfirst + startnum - 1 );
						break;
					}
					else DispNoEvent( 0x02 );
					break;
				}
				case 0x03 :
				{
					if( faultnum > 0 )
					{
						DispEvent( 0x03,faultfirst + faultnum - 1 );
					        break;
					}
					else DispNoEvent( 0x03 );
					break;
				}
			}
			break;
		}
		case 0x03:
		{
			mute = 1;
			sound = 0;
			break;
		}
	}
	keyfirst = ( keyfirst + 1 ) & 0x0F;
	keynum -= 1;
}

void DispEvent(uchar type,uchar loc)
{
	switch(type)
	{
		case 0x01 :
		{
			OutEvent(Fire[loc]);
		  	OutTNum(firenum,type);
		  	OutCur(firecur);
		  	break;
		}
		case 0x02 :
		{
			 OutEvent(Start[loc]);
			 OutTNum(startnum,type);
			 OutCur(startcur);
			 break;
		}
		case 0x03 :
		{
			OutEvent(Fault[loc]);
			OutTNum(faultnum,type);
			OutCur(faultcur);
		}

	}
}
