;LPC769	test program for A/D
;Copy Right reserved by Nanjing WAVE INC. 2003-01-06.

;Following is an example of using the A/D with polling.
;An A/D conversion is started using the channel number supplied in the accumulator.
;The channel number is not checked for validity.
;The A/D must previously have been enabled with sufficient time to allow for stabilization.
;The conversion result is returned in the accumulator.

       $include(lpc769.inc)

       bits   segment bit
       bytes  segment data
       proc   segment code

       rseg   bytes
Channel: ds 1

       rseg   bits
aaa:   dbit 1

       rseg   proc
       org    0
       ljmp   AD_Demo

       org    200h
AD_Demo:
       call   ADInitial
AD_Loop:
       mov    a,#0
       call   ADRead           ;Read channel 0(p0.3)
       mov    a,#1
       call   ADRead           ;Read channel 1(p0.4)
       mov    a,#2
       call   ADRead           ;Read channel 2(p0.5)
       mov    a,#3
       call   ADRead           ;Read channel 3(p0.6)
       jmp    AD_Loop

ADInitial:
       mov    pt0ad,#78h
       orl    p0m1,#78h
       anl    p0m2,#87h
       mov    adcon,#10000100b ;Enable A/D
       mov    a,#9
       call   Delay            ;delay 10ms to stabilize
       ret

ADRead:
       orl    adcon,a          ;Select channel again
       setb   adcs             ;Start A/D
       jnb    adci,$
       mov    a,dac0
       clr    adci             ;Clear A/D complete flag
       anl    adcon,#0fch      ;Clear A/D channel
       ret

Delay:
       MOV    R7, #0
DLP:
       DJNZ   R7, DLP
       DJNZ   acc, DLP
       NOP
       RET

       end

