
; =======================================================================

#define wPORT_NO     1
#define wPORT_POS    5
#define wPW00        0x01234567
#define wPW01        0x76543210
#define wPW10        0x89ABCDEF
#define wPW11        0xFEDCBA98
#define wPowerDelay  6400
#define wJMWait      5
;
; ָʽ UCB Ҫʹһ˫ IO ţ
; P14P15ڲãǽĵ
; wPORT_NO    IO ں   P1
; wPORT_POS   IO λţ P1.5
; wPW00       UCB0 ı PW0 д UCB ʱıͬ
; wPW01       UCB0 ı PW1 д UCB ʱıͬ
; wPW10       UCB1 ı PW0 д UCB ʱıͬ
; wPW11       UCB1 ı PW1 д UCB ʱıͬ
; wPowerDelay XMC4000ϵоƬλĵȴʱ䡣6400Լ1ms, 64000Լ10ms
;             XMC4000ϵоƬڽλʼк
;             ûϵûϵ̻û
;             Ҫȴһʱٿʼг
;             趨СΪ1(ȴ), Ϊ640000(ȴ100ms)
; wJMWait     XMC4000ϵоƬжûJMĴ
;             XMC4000ϵоƬϵжûJMΪϵڼ
;             źŵĲȶܻУҪжϼΡ
;             ÿжһҪʱ30us趨СΪ3, Ϊ100
;
; еΪϵ1msʼжûJM150usȷ5
; ûJMͿʼûJMͿʼԱ
; ֲԾͿʼû, ֶ˾ͽȫƬָʽ
; 

#define wBASE_ADR    (0x48028000 + 0x100 * wPORT_NO)
#define wIOCR_OFS    ((wPORT_POS & 0x0C) + 0x10)
#define wIOCR_MASK   (~(0xF8 << ((wPORT_POS & 0x3) << 3)))
#define wIOCR_INPUT  (0x10 << ((wPORT_POS & 0x3) << 3))
#define wIOCR_OUTPUT (0x80 << ((wPORT_POS & 0x3) << 3))
#define wIN_OFS      (0x24)
#define wOMR_OFS     (0x04)
#define wOMR_0       (0x0001 << (wPORT_POS + 16))
#define wOMR_1       (0x0001 << wPORT_POS)

                ALIGN
pRestore
                LDR     R0, =0x58002000
                LDR     R1, [R0, #0x10]  ; FLASH0->FSR
                LSLS    R12, R1, #15     ; RPRO
                BMI     pMOVE
                B       pUser
pMOVE
                MOV     R0, PC
                LDR     R1, =0xFFFFFFFE
                AND     R0, R1
                LDR     R1, =0x00000FFF
                AND     R1, R1, R0
                LDR     R2, =0x20002000
                ORR     R1, R1, R2
                MOV     R4, R1
                MOV     R2, #256
pCOPY             
                LDR     R3, [R0]
                STR     R3, [R1]
                ADD     R0, R0, #4
                ADD     R1, R1, #4
                SUBS    R2, R2, #1
                BNE     pCOPY
                ADD     R4, R4, #57
                BX      R4
                 
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP

                ; Wait User Board all ready
                LDR     R0, =wPowerDelay
pWaitReady
                SUBS    R0, R0, #1
                BNE     pWaitReady

                LDR     R0, =wBASE_ADR

                ; Set PIN as Input with pull-up
                LDR     R1, [R0, #wIOCR_OFS]
                MOV     R7, R1
                LDR     R2, =wIOCR_MASK
                LDR     R3, =wIOCR_INPUT
                AND     R1, R1, R2
                ORR     R1, R1, R3
                STR     R1, [R0, #wIOCR_OFS]

                LDR     R2, =wJMWait
pWaitPulse
                LDR     R1, [R0, #wIN_OFS]   
                LSLS    R1, R1, #(31-wPORT_POS)
                BMI     pWaitHigh
pWaitLow	  
                MOVS    R3, #80   
pWaitLowLoop	  
                LDR     R1, [R0, #wIN_OFS] 
                LSLS    R1, R1, #(31-wPORT_POS)
                BMI     pWaitHigh
                SUBS    R3, R3, #1
                BNE     pWaitLowLoop
                B       pUser
pWaitHigh
                SUBS    R2, R2, #1
                BEQ     pAck
	  
                MOVS    R3, #80  
pWaitHighLoop	  
                LDR     R1, [R0, #wIN_OFS] 
                LSLS    R1, R1, #(31-wPORT_POS)
                BPL     pWaitLow
                SUBS    R3, R3, #1
                BNE     pWaitHighLoop
                B       pUser
pAck	
                ; Set PIN as output
                LDR     R1, [R0, #wIOCR_OFS]
                LDR     R2, =wIOCR_MASK
                LDR     R3, =wIOCR_OUTPUT
                AND     R1, R1, R2
                ORR     R1, R1, R3
                STR     R1, [R0, #wIOCR_OFS]
             
                ; Send 64 bits 0
                LDR     R1, =wOMR_0
                STR     R1, [R0, #wOMR_OFS]

                MOVS    R2, #64
pSend0
                MOV     R3, #32
pSend0Delay
                SUBS    R3, R3, #1
                BNE     pSend0Delay

                LSLS    R4, R4, #1
                LDR     R1, [R0, #wIN_OFS] 
                LSLS    R1, R1, #(31-wPORT_POS)
                LSRS    R1, R1, #31
                ORRS    R4, R1
	  
                SUBS    R2, R2, #1

                BNE     pSend0

                LDR     R1, =wOMR_1
                STR     R1, [R0, #wOMR_OFS]

                ; Set PIN as Input with pull-up
                LDR     R1, [R0, #wIOCR_OFS]
                LDR     R2, =wIOCR_MASK
                LDR     R3, =wIOCR_INPUT
                AND     R1, R1, R2
                ORR     R1, R1, R3
                STR     R1, [R0, #wIOCR_OFS]

                MOVS    R3, #80 
pWaitDataStart	  
                LDR     R1, [R0, #wIN_OFS] 
                LSLS    R1, R1, #(31-wPORT_POS)
                BPL     pDataStart
                SUBS    R3, R3, #1
                BNE     pWaitDataStart
                B       pUser
pDataStart
                MOV     R3, #16
pStartDelay
                SUBS    R3, R3, #1
                BNE     pStartDelay

                MOVS    R2, #32
pDataReadLoop
                MOV     R3, #32
pSendDelay
                SUBS    R3, R3, #1
                BNE     pSendDelay

                LSLS    R4, R4, #1
                LDR     R1, [R0, #wIN_OFS] 
                LSLS    R1, R1, #(31-wPORT_POS)
                LSRS    R1, R1, #31
                ORRS    R4, R1
	  
                SUBS    R2, R2, #1
                BNE     pDataReadLoop

                LDR     R1, =wPW00
                CMP     R4, R1
                BEQ     pClearUCB
                B       pUser
	  
pClearUCB
pDisableReadWriteProtection
                LDR     R0, =0x58002000
                LDR     R2, =0x0C005554
                LDR     R3, =0x0C00AAA8
                LDR     R4, =0x0C00553C
                LDR     R5, =0x0C005558

                LDR     R1, [R0, #0x10]  ; FLASH0->FSR
                LSLS    R12, R1, #13     ; RPROIN
                BPL     pCheckUCB1

                ; clear status register	
                MOV     R1, #0xF5
                STR     R1, [R2, #0x00]			
	            ; write page 0
                MOV     R1, #0xAA
                STR     R1, [R2, #0x00]
                MOV     R1, #0x55
                STR     R1, [R3, #0x00]
                MOV     R1, #0x00
                STR     R1, [R4, #0x00] ; UCB0

                LDR     R1, =wPW00
                STR     R1, [R3, #0x00]
                LDR     R1, =wPW01
                STR     R1, [R3, #0x00]	

                MOV     R1, #0x08
                STR     R1, [R5, #0x00]	; disable read protection	
          
                ; poll status register
pWaitBusy0
                LDR     R1, [R0, #0x10] ; FLASH0->FSR
                LSLS    R1, R1, #31     ; PBUSY
                BNE     pWaitBusy0
pCheckUCB1
                LDR     R1, [R0, #0x10] ; FLASH0->FSR
                LSLS    R12, R1, #10    ; WPROIN0
                BPL     pCheckUCB2

                ; clear status register	
                MOV     R1, #0xF5
                STR     R1, [R2, #0x00]			
	            ; write page 0
                MOV     R1, #0xAA
                STR     R1, [R2, #0x00]
                MOV     R1, #0x55
                STR     R1, [R3, #0x00]
                MOV     R1, #0x00       
                STR     R1, [R4, #0x00] ; UCB0

                LDR     R1, =wPW00
                STR     R1, [R3, #0x00]
                LDR     R1, =wPW01
                STR     R1, [R3, #0x00]	

                MOV     R1, #0x05
                STR     R1, [R5, #0x00]	; disable write protection	

                ; poll status register
pWaitBusy1
                LDR     R1, [R0, #0x10] ; FLASH0->FSR
                LSLS    R1, R1, #31     ; PBUSY
                BNE     pWaitBusy1
pCheckUCB2
                LDR     R1, [R0, #0x10] ; FLASH0->FSR
                LSLS    R12, R1, #9     ; WPROIN1
                BPL     pEraseUCB0

                ; clear status register	
                MOV     R1, #0xF5
                STR     R1, [R2, #0x00]			
	            ; write page 0
                MOV     R1, #0xAA
                STR     R1, [R2, #0x00]
                MOV     R1, #0x55
                STR     R1, [R3, #0x00]
                MOV     R1, #0x01       
                STR     R1, [R4, #0x00] ; UCB1

                LDR     R1, =wPW10
                STR     R1, [R3, #0x00]
                LDR     R1, =wPW11
                STR     R1, [R3, #0x00]	

                MOV     R1, #0x05
                STR     R1, [R5, #0x00]	; disable write protection	

                ; poll status register
pWaitBusy2
                LDR     R1, [R0, #0x10] ; FLASH0->FSR
                LSLS    R1, R1, #31     ; PBUSY
                BNE     pWaitBusy2
pEraseUCB0
                LDR     R5, =0x0C000000 ; UCB0
                ; clear status register
                MOV     R1, #0xF5
                STR     R1, [R2, #0x00]

	            ; erase physical sector	
                MOV     R1, #0xAA
                STR     R1, [R2, #0x00]
                MOV     R1, #0x55
                STR     R1, [R3, #0x00]
                MOV     R1, #0x80
                STR     R1, [R2, #0x00]
                MOV     R1, #0xAA
                STR     R1, [R2, #0x00]
                MOV     R1, #0x55
                STR     R1, [R3, #0x00]

                MOV     R1, #0xC0        ; erase UCB block
                STR     R1, [R5, #0x00]  ; UCB0
	
                ; poll status register
pWaitBusy3
                LDR     R1, [R0, #0x10] ; FLASH0->FSR
                LSLS    R1, R1, #31     ; PBUSY
                BNE     pWaitBusy3
          
pEraseUCB1
                LDR     R5, =0x0C000400 ; UCB1
                ; clear status register
                MOV     R1, #0xF5
                STR     R1, [R2, #0x00]

	            ; erase physical sector	
                MOV     R1, #0xAA
                STR     R1, [R2, #0x00]
                MOV     R1, #0x55
                STR     R1, [R3, #0x00]
                MOV     R1, #0x80
                STR     R1, [R2, #0x00]
                MOV     R1, #0xAA
                STR     R1, [R2, #0x00]
                MOV     R1, #0x55
                STR     R1, [R3, #0x00]

                MOV     R1, #0xC0        ; erase UCB block
                STR     R1, [R5, #0x00]  ; UCB1
	
                ; poll status register
pWaitBusy4
                LDR     R1, [R0, #0x10] ; FLASH0->FSR
                LSLS    R1, R1, #31     ; PBUSY
                BNE     pWaitBusy4
	  
                B       .
	  
pUser		
                
; =======================================================================
