/******************************************************************************/
/*  This file is part of the ARM Toolchain package                            */
/*  Copyright KEIL ELEKTRONIK GmbH 2003 - 2008                                */
/******************************************************************************/
/*                                                                            */
/*  FlashDev.C:  Device Description for External SPI Flash                    */
/*               M25P64 programming with ST STM32F10x Devices                 */
/*                                                                            */
/******************************************************************************/

#include "FlashOS.H"        // FlashOS Structures


struct FlashDevice const FlashDevice  =  {
   FLASH_DRV_VERS,              // Driver Version, do not modify!
   "WaveTEST 24C02 IIC EEPROM", //Device Name
   UNKNOWN,                     // Device Type
   0x00000000,                  // Device Start Address
   0x00000100,                  // Device Size in Bytes (2MB for w25x16)
   0x8,                         // Programming Page Size 
                                // Pagesize 8B for 02, 16B for 04/0816, 32B for 32/64
   0,                           // Reserved, must be 0
   0xFF,                        // Initial Content of Erased Memory
   2000,                        // Program Page Timeout 100 mSec
   2000,                        // Erase Sector Timeout 3000 mSec
   // Specify Size and Address of Sectors
   0x8    , 0x000000,          // Sector Size 65kB (128 Sectors)
   SECTOR_END
};
