/******************************************************************************/
/*  This file is part of the ARM Toolchain package                            */
/*  Copyright KEIL ELEKTRONIK GmbH 2003 - 2008                                */
/******************************************************************************/
/*                                                                            */
/*  FlashPrg.C:  Flash Programming Functions adapted for External SPI Flash   */
/*               M25P64 programming with ST STM32F10x Devices                 */
/*                                                                            */
/******************************************************************************/

#include "FlashOS.H"        // FlashOS Structures

#define AT24C01		127
#define AT24C02		255
#define AT24C04		511
#define AT24C08		1023
#define AT24C16		2047
#define AT24C32		4095
#define AT24C64	    8191
#define AT24C128	16383
#define AT24C256	32767  
#define EE_TYPE AT24C02

typedef volatile unsigned char  vu8;
typedef volatile unsigned long  vu32;
typedef volatile unsigned short vu16;

 // Read Only 
typedef volatile unsigned long  const vuc32; 

typedef unsigned char u8;

#define M8(adr)  (*((vu8  *) (adr)))
#define M16(adr) (*((vu16 *) (adr)))
#define M32(adr) (*((vu32 *) (adr)))


typedef unsigned short     int uint16_t;
typedef unsigned           int uint32_t;
typedef unsigned           int u32     ;
typedef unsigned           char u8    ;
typedef unsigned short     int u16     ;

//!< defines 'read / write' permissions  
#define __IO               volatile  
                
typedef struct
{
  __IO uint32_t CR;
  __IO uint32_t CFGR;
  __IO uint32_t CIR;
  __IO uint32_t APB2RSTR;
  __IO uint32_t APB1RSTR;
  __IO uint32_t AHBENR;
  __IO uint32_t APB2ENR;
  __IO uint32_t APB1ENR;
  __IO uint32_t BDCR;
  __IO uint32_t CSR;
} RCC_TypeDef;

typedef struct
{
  __IO uint32_t CRL;
  __IO uint32_t CRH;
  __IO uint32_t IDR;
  __IO uint32_t ODR;
  __IO uint32_t BSRR;
  __IO uint32_t BRR;
  __IO uint32_t LCKR;
} GPIO_TypeDef;

typedef struct
{
  vu16 CR1;
  u16  RESERVED0;
  vu16 CR2;
  u16  RESERVED1;
  vu16 OAR1;
  u16  RESERVED2;
  vu16 OAR2;
  u16  RESERVED3;
  vu16 DR;
  u16  RESERVED4;
  vu16 SR1;
  u16  RESERVED5;
  vu16 SR2;
  u16  RESERVED6;
  vu16 CCR;
  u16  RESERVED7;
  vu16 TRISE;
  u16  RESERVED8;
} I2C_TypeDef;


extern struct FlashDevice const FlashDevice;
#define PERIPH_BASE      ((uint32_t)0x40000000) //!< Peripheral base address in the alias region 
#define APB2PERIPH_BASE  (PERIPH_BASE + 0x10000)
#define AHBPERIPH_BASE   (PERIPH_BASE + 0x20000)

#define RCC_BASE         (AHBPERIPH_BASE  + 0x1000)
#define GPIOC_BASE       (APB2PERIPH_BASE + 0x1000)
#define GPIOC_ODR_Addr    (GPIOC_BASE+12) //0x4001100C 
#define GPIOC_IDR_Addr    (GPIOC_BASE+8)  //0x40011008 

#define RCC              ((RCC_TypeDef  *) RCC_BASE  )
#define GPIOC            ((GPIO_TypeDef *) GPIOC_BASE)

/* 
//SCL PC12
#define SCL0             0x10000000
#define SCL1             0x00001000
//SDA PC11
#define SDA0             0x08000000
#define SDA1             0x00000800

#define IICSCL          (GPIOC->BSRR)
#define IICSDA          (GPIOC->BSRR)
*/

#define BITBAND(addr, bitnum) ((addr & 0xF0000000)+0x2000000+((addr &0xFFFFF)<<5)+(bitnum<<2)) 
#define MEM_ADDR(addr)  *((volatile unsigned long  *)(addr)) 
#define BIT_ADDR(addr, bitnum)   MEM_ADDR(BITBAND(addr, bitnum)) 
#define PCout(n)   BIT_ADDR(GPIOC_ODR_Addr,n)  // 
#define PCin(n)    BIT_ADDR(GPIOC_IDR_Addr,n)  // 

#define IIC_SCL    PCout(12) //SCL
#define IIC_SDA    PCout(11) //SDA	 
#define READ_SDA   PCin(11)  //SDA 

//ʱnus
//nusΪҪʱus.		    								   
void delay_us(u32 nus)
{
    // about 1 us in 8mhz sysclk
  	while(nus--){}
}

unsigned char aux_buf[256];
#define SDA_IN()  {GPIOC->CRH&=0XFFFF0FFF;GPIOC->CRH|=8<<12;}
#define SDA_OUT() {GPIOC->CRH&=0XFFFF0FFF;GPIOC->CRH|=3<<12;}

//ʼIIC
void IIC_Init(void)
{
	RCC->CFGR &=0XFFFFfFFc;	// ѡHSIΪϵͳʱ		     
		     
	RCC->APB2ENR|=1<<4 ;    //ʹIO PORTCʱ 							 
	GPIOC->CRH&=0XFFF00FFF; //PC11/12 
	GPIOC->CRH|=0X00033000;	   
	GPIOC->ODR|=3<<11;      //PC11,12 
}
//IICʼź
void IIC_Start(void)
{
	SDA_OUT();     //sda
	IIC_SDA = 1;	  	  
	IIC_SCL = 1;
	delay_us(2);
 	IIC_SDA =0;//START:when CLK is high,DATA change form high to low 
	delay_us(2);
	IIC_SCL =0;//ǯסI2Cߣ׼ͻ 
}	  
//IICֹͣź
void IIC_Stop(void)
{
	SDA_OUT();//sda
	IIC_SCL = 0;
	IIC_SDA = 0;//STOP:when CLK is high DATA change form low to high
 	delay_us(2);
	IIC_SCL = 1; 
	IIC_SDA = 1;//I2C߽ź
	delay_us(2);							   	
}
//ȴӦźŵ
//ֵ1Ӧʧ
//        0Ӧɹ
u8 IIC_Wait_Ack(void)
{
	u8 ucErrTime = 0;
	SDA_IN();      //SDAΪ  
	IIC_SDA = 1;
	delay_us(2);	   
	IIC_SCL = 1;
	delay_us(2);	 
	while(READ_SDA)
	{
		ucErrTime++;
		if(ucErrTime>250)
		{
			IIC_Stop();
			return 1;
		}
	}
	IIC_SCL = 0;//ʱ0 	   
	return 0;  
} 
//ACKӦ
void IIC_Ack(void)
{
	IIC_SCL = 0;
	SDA_OUT();
	IIC_SDA = 0;
	delay_us(2);
	IIC_SCL = 1;
	delay_us(2);
	IIC_SCL = 0;
}
//ACKӦ		    
void IIC_NAck(void)
{
	IIC_SCL = 0;
	SDA_OUT();
	IIC_SDA = 1;
	delay_us(2);
	IIC_SCL = 1;
	delay_us(2);
	IIC_SCL = 0;
}					 				     
//IICһֽ
//شӻӦ
//1Ӧ
//0Ӧ			  
void IIC_Send_Byte(u8 txd)
{                        
    u8 t;   
	SDA_OUT(); 	    
    IIC_SCL = 0;//ʱӿʼݴ
    for(t=0;t<8;t++)
    {   
	    if(txd&0x80) IIC_SDA = 1; else IIC_SDA = 0;          
        //IIC_SDA=(txd&0x80)>>7;
        txd<<=1; 	  
		delay_us(2);   //TEA5767ʱǱ
		IIC_SCL = 1;
		delay_us(2); 
		IIC_SCL = 0;	
		//delay_us(1);
    }	 
} 	    
//1ֽڣack=1ʱACKack=0nACK   
u8 IIC_Read_Byte(unsigned char ack)
{
	unsigned char i,receive=0;
	SDA_IN();//SDAΪ
    for(i=0;i<8;i++ )
	{
        IIC_SCL = 0; 
        delay_us(2);
		IIC_SCL = 1;
        receive<<=1;
        if(READ_SDA)receive++;   
		delay_us(2); 
    }					 
    if (!ack)
        IIC_NAck();//nACK
    else
        IIC_Ack(); //ACK   
    return receive;
}


//ʼIICӿ
void AT24CXX_Init(void)
{
	IIC_Init();
}
//AT24CXXַָһ
//ReadAddr:ʼĵַ  
//ֵ  :
u8 AT24CXX_ReadOneByte(u16 ReadAddr)
{				  
	u8 temp=0;		  	    																 
    IIC_Start();  
	if(EE_TYPE>AT24C16)
	{
		IIC_Send_Byte(0XA0);	   //д
		IIC_Wait_Ack();
		IIC_Send_Byte(ReadAddr>>8);//͸ߵַ	    
	}else 
	    IIC_Send_Byte(0XA0+((ReadAddr/256)<<1));   //ַ0XA0,д
		 	   
	IIC_Wait_Ack(); 
    IIC_Send_Byte(ReadAddr%256);   //͵͵ַ
	IIC_Wait_Ack();	    
	IIC_Start();  	 	   
	if(EE_TYPE>AT24C16)IIC_Send_Byte(0XA1);         //ģʽ 
	else IIC_Send_Byte(0XA1+((ReadAddr/256)<<1));   //ģʽ 
 	IIC_Wait_Ack();	 
    temp=IIC_Read_Byte(0);		   
    IIC_Stop();//һֹͣ	    
	return temp;
}
//AT24CXXַָдһ
//WriteAddr  :дݵĿĵַ    
//DataToWrite:Ҫд
void AT24CXX_WriteOneByte(u16 WriteAddr,u8 DataToWrite)
{				   	  	    																 
    IIC_Start();  
	if(EE_TYPE>AT24C16)
	{
		IIC_Send_Byte(0XA0);	    //д
		IIC_Wait_Ack();
		IIC_Send_Byte(WriteAddr>>8);//͸ߵַ	  
	}else 
	    IIC_Send_Byte(0XA0+((WriteAddr/256)<<1));   //ַ0XA0,д 	 
	IIC_Wait_Ack();	   
    IIC_Send_Byte(WriteAddr%256);   //͵͵ַ
	IIC_Wait_Ack(); 	 										  		   
	IIC_Send_Byte(DataToWrite);     //ֽ							   
	IIC_Wait_Ack();  		    	   
    IIC_Stop();//һֹͣ 
	delay_us(5000);	 
}
//AT24CXXַָʼд볤ΪLen
//úд16bit32bit.
//WriteAddr  :ʼдĵַ  
//DataToWrite:׵ַ
//Len        :Ҫдݵĳ2,4
void AT24CXX_WriteLenByte(u16 WriteAddr,u32 DataToWrite,u8 Len)
{  	
	u8 t;
	for(t=0;t<Len;t++)
	{
		AT24CXX_WriteOneByte(WriteAddr+t,(DataToWrite>>(8*t))&0xff);
	}												    
}

//AT24CXXַָʼΪLen
//úڶ16bit32bit.
//ReadAddr   :ʼĵַ 
//ֵ     :
//Len        :Ҫݵĳ2,4
u32 AT24CXX_ReadLenByte(u16 ReadAddr,u8 Len)
{  	
	u8 t;
	u32 temp=0;
	for(t=0;t<Len;t++)
	{
		temp<<=8;
		temp+=AT24CXX_ReadOneByte(ReadAddr+Len-t-1); 	 				   
	}
	return temp;												    
}
//AT24CXXǷ
//24XXһַ(255)洢־.
//24Cϵ,ַҪ޸
//1:ʧ
//0:ɹ
u8 AT24CXX_Check(void)
{
	u8 temp;
	temp=AT24CXX_ReadOneByte(255);//ÿοдAT24CXX			   
	if(temp==0X55)return 0;		   
	else//ųһγʼ
	{
		AT24CXX_WriteOneByte(255,0X55);
	    temp=AT24CXX_ReadOneByte(255);	  
		if(temp==0X55)return 0;
	}
	return 1;											  
}

//AT24CXXַָʼָ
//ReadAddr :ʼĵַ 24c02Ϊ0~255
//pBuffer  :׵ַ
//NumToRead:Ҫݵĸ
void AT24CXX_Read(u16 ReadAddr,u8 *pBuffer,u16 NumToRead)
{
	while(NumToRead)
	{
		*pBuffer++=AT24CXX_ReadOneByte(ReadAddr++);	
		NumToRead--;
	}
}  
//AT24CXXַָʼдָ
//WriteAddr :ʼдĵַ 24c02Ϊ0~255
//pBuffer   :׵ַ
//NumToWrite:Ҫдݵĸ
void AT24CXX_Write(u16 WriteAddr,u8 *pBuffer,u16 NumToWrite)
{
	while(NumToWrite--)
	{
		AT24CXX_WriteOneByte(WriteAddr,*pBuffer);
		WriteAddr++;
		pBuffer++;
	}
}


int Init (void) {

  AT24CXX_Init();
  
  return (0);
}


int UnInit (unsigned long fnc) {

  return (0);
}

/*/
int EraseChip (void)
{

  //u8 NumToWrite = FlashDevice.szDev;
  u8 adr =0;
   
	for(adr =0; adr <256; adr++)
	//while(NumToWrite--)
	{
		AT24CXX_WriteOneByte(adr,0xff);
		//adr++;
	}

  return (0);                                   // Done
}
/ */
int  EraseSector (unsigned long adr)
{

  u8 i =0;
   
	for(i=0; i <8; i++)
	{
		AT24CXX_WriteOneByte(adr+i,0xff);
		//i ++;
	}

  return (0);                                   // Done
}


int ProgramPage (unsigned long adr, unsigned long sz, unsigned char *buf)
{

  AT24CXX_Write(adr, buf, sz);

  return (0);                                   // Done
}

int Read(unsigned long adr, unsigned long sz, unsigned char *buf)
{
   AT24CXX_Read(adr, (u8* )buf, sz);	
   return(0);
}

/* debug function 
void WriteCS(u32 D)
{
  u32 i, j;

  D |= 0xFF00;
  D <<= 1;
  SPI_FLASH_CS_HIGH();
  for (i=0; i<11; i++) {
    if (D & 1) SPI_FLASH_CS_HIGH(); else SPI_FLASH_CS_LOW();
	for (j=0; j<1000; j++);
	D >>= 1;    
  }
}
 */
int  BlankCheck(unsigned long adr, unsigned long sz, unsigned char pat)
{
  int i;
  u8* pt1;

  AT24CXX_Read(adr, (u8 *)aux_buf, sz);	

  pt1 =(u8*) aux_buf;

  for (i = 0; i< sz; i++) {
    if (*pt1++ != 0xff){ 
      return (adr+i);                   // Verification Failed (return address)
    }
  }

  return (0);                     // Done successfully
  
};


int  Verify (unsigned long adr, unsigned long sz, unsigned char *buf) 
{

  int i;
  u8* pt1;
  u8* pt2;

  AT24CXX_Read(adr, (u8 *)aux_buf, sz);	

  pt1 =(u8*) aux_buf;
  pt2 =(u8*) buf;

  for (i = 0; i< sz; i++) {
    if (*pt1++ != *pt2++){ 
      return (adr+i);                   // Verification Failed (return address)
    }
  }

  return (0);                     // Done successfully
  
}

