
// JM3_DEF

typedef unsigned char u8 ;
typedef unsigned int  u32;

struct PluginType  {
   u32  ID      ; // ID
   u8   IDS[128]; // ID Description
};

#define bPIN2  0x01
#define bPIN3  0x02
#define bPIN4  0x04
#define bPIN5  0x08
#define bPIN6  0x10
#define bPIN7  0x20
#define bPIN9  0x40
#define bDEVEN 0x80
//  bDEVEN λΪ 0 ʱʾб̽Ϊһ IO ,  bDEVEN λΪ 1 ʱʾر̽ΪӲ, ̽Ϊһ IO  

// PowerCtrl
#define bPowerVIO   0x01
#define bPowerVCC5  0x02
#define bPowerLEDR  0x04
#define bPowerLEDG  0x08
#define bPowerLEDF  0x10

// address
#define aPowerCtrl  0x00
#define aIOCtrl     0x01
#define aIOData     0x02   // both read/write use same address
#define aATE        0x03
#define aJM3_KEY    0x7C

#define bATE_BUSY   0x01
#define bATE_OK     0x02
#define bATE_NG     0x04

#define FileBufSize 1024

#define wOS_GetMemory  (*(u32 (*)()) * (pV+ 0))
#define wOS_Write      (*(u32 (*)()) * (pV+ 1))
#define wOS_Read       (*(u32 (*)()) * (pV+ 4))
#define wOS_Sleep      (*(u32 (*)()) * (pV+ 8))
#define wOS_Wait       (*(u32 (*)()) * (pV+ 9))
#define wOS_Status     (*(u32 (*)()) * (pV+10))
#define wOS_Write32    (*(u32 (*)()) * (pV+14))
#define wOS_Read32     (*(u32 (*)()) * (pV+15))

// u8  * wOS_GetMemory(u32 * pV, u32 A  , u32 LEN)  pV: ȫֱָ   A  : ݵַ  LEN:    
//   ݡ
//   ֵ: ָ   ָΪ NIL(0xFFFFFFFF) ʱʾûӦı


// void  wOS_Write    (u32 * pV, u32 ADR, u32 DAT)  pV: ȫֱָ   ADR: Ĵַ    DAT: (8λ) 
//   дĴ(8λ)    

// u32   wOS_Read     (u32 * pV, u32 ADR         )  pV: ȫֱָ   ADR: Ĵַ                               
//    Ĵ(8λ)
//    ֵ: (8λ)

// void  wOS_Sleep    (u32 * pV, u32 W           )  pV: ȫֱָ   W  : ʱ(ms)
//    ʱ     жϵǰִ, ʱʱ䵽ټִ

// u32   wOS_Wait     (u32 * pV, u32 W  , u32 AMD)  pV: ȫֱָ   W  : ʱ(ms)  AMD: ADDR|MASK|DATA  
//    ȴ¼ жϵǰִ, ȴ¼ʱټִ
//       W(ms) ʱ,  ADDR Ĵ MASK  DATA ͷ 0, ʱط 0
//      ADDR: 23..16λ     MASK: 15..8λ   DATA: 7..0λ
//    ֵ: 0: ȴ¼ 0: ȴ¼δ, ʱ           

// void  wOS_Status   (u32 * pV, u32 S           )  pV: ȫֱָ   S  : ״̬ 
//    ±״̬ 

// void  wOS_Write32  (u32 * pV, u32 ADR, u32 DAT)  pV: ȫֱָ   ADR: Ĵַ    DAT: (32λ)
//    дĴ(32λ)    

// u32   wOS_Read32   (u32 * pV, u32 ADR         )  pV: ȫֱָ   ADR: Ĵַ                                  
//    Ĵ(32λ)
//    ֵ: (32λ) 

// ȫֱƫ
#define o_No           (40*4)
#define o_Err          (41*4)
#define o_SpeedBar     (48*4)
#define o_PowerCtrl    (49*4)
#define o_IOCtrl       (50*4)
#define o_IOData       (51*4)
#define o_PGCTRL       (66*4)

// ȫֱ
#define vNo            (*(pV+(o_No/4        )))
#define vErr           (*(pV+(o_Err/4       )))
#define vSpeedBar      (*(pV+(o_SpeedBar/4  )))
#define vPowerCtrl     (*(pV+(o_PowerCtrl/4 )))
#define vIOCtrl        (*(pV+(o_IOCtrl/4    )))
#define vIOData        (*(pV+(o_IOData/4    )))
#define vPGCTRL        (*(pV+(o_PGCTRL/4    )))

// vNo        : ̿ں  0: P1 ̿     1: P2 ̿ 
// vErr       : ̴  0: ûз   0: 
// vSpeedBar  : ״̬λ(0..20) λ(31λ)Ϊ1ʱʾҪ״̬
// vPowerCtrl : ̿ڵԴLEDʾ
// vIOCtrl    : ̿ڹܼ
// vIOData    : ̿
// vPGCTRL    : ѡ

#define NIL            0xFFFFFFFF

#define bPGNull        0x00000000
#define bPGWaitKey     0x00000001
#define bPGAuto        0x00000002
#define bPGTestPIN     0x00000004
#define bPGConnect     0x00000008
#define bPGRestore     0x00000010
#define bPGErase       0x00000020
#define bPGWrite       0x00000040
#define bPGRead        0x00000080
#define bPGVerify      0x00000100
#define bPGProtect     0x00000200
#define bPGUnProtect   0x00000400
#define bPGBlankCheck  0x00000800
#define bPGCTRL        0x00001000
#define bPGEPROM       0x00002000
#define bPGBootLoad    0x00004000
#define bPGATE         0x00008000

#define bPGSVF         0x00010000
#define pPGIDCODE      0x00020000
#define bPGCheckOPT    0x00040000
#define bPGPIO         0x00080000
#define bPGWriteOPT    0x00100000
#define bPGReadOPT     0x00200000
#define bPGTEST        0x00400000
#define bPGUserID0     0x00800000
#define bPGUserID1     0x01000000
#define bPGUserID2     0x02000000

#define bPGExecute     0x04000000
#define bPGJMONo       0x08000000
#define bPGDownload    0x10000000
#define bPGPowerOn     0x20000000
#define bPGPowerOff    0x40000000
#define bPGFinish      0x80000000

#define pBEFORE        0
#define pAFTER         1

// vP1
#define vNo1           (*(pV1+(o_No/4        )))
#define vErr1          (*(pV1+(o_Err/4       )))
#define vSpeedBar1     (*(pV1+(o_SpeedBar/4  )))
#define vPowerCtrl1    (*(pV1+(o_PowerCtrl/4 )))
#define vIOCtrl1       (*(pV1+(o_IOCtrl/4    )))
#define vIOData1       (*(pV1+(o_IOData/4    )))
#define vPGCTRL1       (*(pV1+(o_PGCTRL/4    )))

// vP2
#define vNo2           (*(pV2+(o_No/4        )))
#define vErr2          (*(pV2+(o_Err/4       )))
#define vSpeedBar2     (*(pV2+(o_SpeedBar/4  )))
#define vPowerCtrl2    (*(pV2+(o_PowerCtrl/4 )))
#define vIOCtrl2       (*(pV2+(o_IOCtrl/4    )))
#define vIOData2       (*(pV2+(o_IOData/4    )))
#define vPGCTRL2       (*(pV2+(o_PGCTRL/4    )))
