
// ģһ UART ڣ 9600  Ϊ 104.17us
// SWD ʱ, PIN2PIN4PIN5PIN6 ûʹ, ǿ PIN4, PIN5 ģһ UART 
// ʹȫֱĺҪ pV ʹþֲĺҪ pL 

#include "../INC/JM3_DEF.H"        
#include "../INC/JM3_VAR.H"

struct PluginType const vPlugin = {
  0xFFFF0004,                   // ID
  "STM32F1xx SUART Plugin",     // ID Description
};

// RXD, TXD ܽŶ
#define bRXD          bPIN4
#define bTXD          bPIN5

#define BufferSize    0x80
// pL ƫ
#define oReadCounter  0x000
#define oWriteCounter 0x004
#define oReadBuffer   0x080
#define oWriteBuffer  (oReadBuffer + BufferSize)

// pL1 ַ
#define aReadBuffer1  (aLOCAL1 + oReadBuffer )
#define aWriteBuffer1 (aLOCAL1 + oWriteBuffer)
// pL2 ַ
#define aReadBuffer2  (aLOCAL2 + oReadBuffer)
#define aWriteBuffer2 (aLOCAL2 + oWriteBuffer)

// pL ָ붨
#define pReadBuffer   ((u8 *)pL + oReadBuffer )
#define pWriteBuffer  ((u8 *)pL + oWriteBuffer)
// pL1 ָ붨
#define pReadBuffer1  ((u8 *)(aReadBuffer1 ))
#define pWriteBuffer1 ((u8 *)(aWriteBuffer1))
// pL2 ָ붨
#define pReadBuffer2  ((u8 *)(aReadBuffer2 ))
#define pWriteBuffer2 ((u8 *)(aWriteBuffer2))

//  vReadCounter, vWriteCounter
#define vReadCounter  (*(pL+(oReadCounter /4 )))
#define vWriteCounter (*(pL+(oWriteCounter/4)))

// pL1 
u8  vReadBuffer1 [BufferSize] __attribute__ ((at(aLOCAL1 + oReadBuffer )));
u8  vWriteBuffer1[BufferSize] __attribute__ ((at(aLOCAL1 + oWriteBuffer)));
// pL2 
u8  vReadBuffer2 [BufferSize] __attribute__ ((at(aLOCAL2 + oReadBuffer )));
u8  vWriteBuffer2[BufferSize] __attribute__ ((at(aLOCAL2 + oWriteBuffer)));

// ж
__asm void CPSID(void)
{
    CPSID i
    BX    LR
}

// ж
__asm void CPSIE(void)
{
    CPSIE i
    BX    LR
}

void InitUART(u32 * pV, u32 * pL)
{  
  vIOCtrl &= ~bRXD;                    //  RXD Ϊ        
  vIOCtrl |=  bTXD;                    //  TXD Ϊ
  wOS_Write(pV, aIOCtrl, vIOCtrl);     // д IO ƼĴ
  vIOData |= bRXD + bTXD;              //  RXD, TXD ø
  wOS_Write(pV, aIOData, vIOData);     // д IO ݼĴ

  vReadCounter  = 0;
  vWriteCounter = 0;

  return;  
}

// ʱ
// ûʹȫֱֲ, ôpV, pL
void Delay(u32 CNT)
{
  while (CNT--) ;
}

u8 ReadUART(u32 * pV, u32 * pL)
{
  u8  Data8;
  u32 i    ;

  Data8 = 0;

  // ʼλ,  RXD = 0 ʱյʼλ
  while (wOS_Read(pV, aIOData) & bRXD) ;

  CPSID();         // ж
  Delay(1850/2);   //  104.17us / 2  
  
  //  8 λ
  for (i=0; i<8; i++) {
    Delay(1850);   //  104.17us
    Data8 >>= 1;
    if (wOS_Read(pV, aIOData) & bRXD) Data8 |= 0x80; else Data8 &= 0x7F;
  }

  // ֹͣλ
  Delay(1850/2);   

  CPSIE();         // ж

  //  + 1
  vReadCounter++;
  return(Data8);
}

void WriteUART(u32 * pV, u32 * pL, u8 Data)
{
  u32 Output;
  u32 i     ;

  Output = (Data << 1) | 0x200;   // ʼλΪ 0ֹͣλΪ 1

  CPSID();  // ж
  // 8 λ + 1 ʼλ + 1 ֹͣλ  10 λ
  for (i=0; i<10; i++) {
    if (Output & 1) vIOData |= bTXD; else vIOData &= ~bTXD;
    wOS_Write(pV, aIOData, vIOData);
    Delay(1850);   //  104.17us  
    Output >>= 1;
  }
  CPSIE();  // ж

  // д + 1
  vWriteCounter++;

}

u32 ReadUART32(u32 * pV, u32 * pL)
{
  u8 * pW    ;
  u32  Data32;

  //  4 ֽ, һ32λ
  pW = pReadBuffer;

  *pW++ = ReadUART(pV, pL); 
  *pW++ = ReadUART(pV, pL); 
  *pW++ = ReadUART(pV, pL); 
  *pW++ = ReadUART(pV, pL); 

  pW = pReadBuffer;
  Data32  = *pW++;
  Data32 += (*pW++) <<  8;
  Data32 += (*pW++) << 16;
  Data32 += (*pW++) << 24;

  return(Data32);
}

const u8 ASCII[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

void WriteUART32(u32 * pV, u32 * pL, u32 Data32)
{
  u8  * pW;
  u32   i ;

  // תΪ ASCII
  pW = pWriteBuffer;

  *pW++ = ASCII[(Data32 >> 28) & 0xF]; Data32 <<= 4;
  *pW++ = ASCII[(Data32 >> 28) & 0xF]; Data32 <<= 4;
  *pW++ = ASCII[(Data32 >> 28) & 0xF]; Data32 <<= 4;
  *pW++ = ASCII[(Data32 >> 28) & 0xF]; Data32 <<= 4;
  *pW++ = ASCII[(Data32 >> 28) & 0xF]; Data32 <<= 4;
  *pW++ = ASCII[(Data32 >> 28) & 0xF]; Data32 <<= 4;
  *pW++ = ASCII[(Data32 >> 28) & 0xF]; Data32 <<= 4;
  *pW++ = ASCII[(Data32 >> 28) & 0xF]; Data32 <<= 4;
  
  pW = pWriteBuffer;
  for (i=0; i<8; i++) WriteUART(pV, pL, *pW++);  
}

void TestUART(u32 * pV, u32 * pL)
{
  u32 Data32;

  do {
    //  4 ֽ
    Data32 = ReadUART32(pV, pL);
    // תΪ ASCII 
    WriteUART32(pV, pL, Data32);
  } while (Data32 != 0); 
  // յ 0 
  return;  
}

// pV: ȫֱָ   pL: ֲָ   vPos: pBEFORE, pAFTER   vOption: ̶
u32 Run(u32 * pV, u32 * pL, u32 vPos, u32 vOption)
{
  if ( (vPos == pAFTER) && (vOption == bPGConnect) ) { // (Connect)оƬɹʼ UART
    InitUART(pV, pL);
  } else if ( vOption == bPGTestPIN ) {                // ڱ UART
    TestUART(pV, pL);
  }

  return(0);
}
