
//  SWD  UCID  IDCODE FLASH  0x08002F00 - 0x08002F0F
// ʹȫֱĺҪ pV ʹþֲĺҪ pL 

#include "../INC/JM3_DEF.H"        
#include "../INC/JM3_VAR.H"
#include "../INC/JM3_SWD.H"
#include "../INC/STM32.H"

struct PluginType const vPlugin = {
  0xFFFF0005,                  // ID
  "STM32F1xx SWD Plugin",      // ID Description
};

#define WaitTimes 1000

// ֲƫ
#define o_SWCtrl       0
#define o_aCSW         4
#define o_dIDCODE      8
#define o_aDHCSR      12
#define o_LocalVar    16
#define o_Free        20
#define o_Breakpoint  24
#define o_UniqueID0_3 28
#define o_UniqueID4_7 32
#define o_UniqueID8_B 36

// ֲ
#define vSWCtrl       (*(pL+(o_SWCtrl     /4)))
#define vaCSW         (*(pL+(o_aCSW       /4)))
#define vdIDCODE      (*(pL+(o_dIDCODE    /4)))
#define vaDHCSR       (*(pL+(o_aDHCSR     /4)))
#define vLocalVar     (*(pL+(o_LocalVar   /4)))
#define vFree         (*(pL+(o_Free       /4)))
#define vBreakpoint   (*(pL+(o_Breakpoint /4)))
#define vUniqueID0_3  (*(pL+(o_UniqueID0_3/4)))
#define vUniqueID4_7  (*(pL+(o_UniqueID4_7/4)))
#define vUniqueID8_B  (*(pL+(o_UniqueID8_B/4)))

// SWD忪ʼ===========================================================================

u32 Read32(u32 * pV)
{
  u8   b       ;
  u32  DATA    ;
  u32  TryTimes;

  if (vErr) return(0xFFFFFFFF);

  TryTimes = WaitTimes; 
  do {
    b = wOS_Read(pV, aSWCtrl);
    TryTimes--;
  } while ( (b & bDEmpty) && ((b & bERROR) == 0) && (TryTimes) );

  if (TryTimes == 0) {
    vErr = 1;
    DATA = 0xFFFFFFFF;
  } else if (b & bERROR) {
    vErr = 1;
    DATA = 0xFFFFFFFF; 
  } else {
    DATA  = wOS_Read32(pV, aSWDATA);
  }

  return(DATA);

}

void Write32(u32 * pV, u32 DATA)
{
  if (vErr) return;

  wOS_Write32(pV, aSWDATA, DATA);
}

u32 DBG_Read(u32 * pV, u32 * pL, u32 Adr)
{
  if (vErr) return(0);

  // wa4, Adr   write a_TAR   TAR = Adr
  Write32(pV, Adr);
  wOS_Write(pV, aSWCMD, bAPnDP + bA2);

  // rac	read aC   a_DRW
  wOS_Write(pV, aSWCMD, bAPnDP + bRnW + bA2 + bA3); // rac 
  wOS_Write(pV, aSWCMD, bRnW + bA2 + bA3 + bREAD );	// rdc read d_RDBUFF
  
  return(Read32(pV));
}

/*
void DBG_Write(u32 * pV, u32 * pL, u32 Adr, u32 Data)
{
  if (vErr) return;

  // wa4, Adr   write a_TAR   TAR = Adr
  Write32(pV, Adr);
  wOS_Write(pV, aSWCMD, bAPnDP + bA2);

  Write32(pV, Data);
  // wac	write aC   a_DRW
  wOS_Write(pV, aSWCMD, bAPnDP + bA2 + bA3);  
  
}

void DBG_WriteRUN(u32 * pV, u32 * pL, u32 Adr, u32 Data)
{
  u32 S, C;

  if (vErr) return;

  // wa4, Adr   write a_TAR   TAR = Adr
  Write32(pV, Adr);
  wOS_Write(pV, aSWCMD, bAPnDP + bA2);

  // wait all command send out
  C = 100;
  do {
    S = wOS_Read(pV, aSWStatus);
    if ( (S & (bBUSY | bCEmpty)) == bCEmpty ) C = 0; else C--; // empty and not busy
  } while (C);

  // set SetRun
  wOS_Write(pV, aSWCtrl, (vSWCtrl & 0xff) | bClrRun | bSetRun);

  Write32(pV, Data);
  // wac	write aC   a_DRW
  wOS_Write(pV, aSWCMD, bAPnDP + bA2 + bA3);  


  // wait 10ms
  C = 100;

  do {
    S = DBG_Read(pV, pL, aDHCSR);

    // if HALT then clear RUN
    if (S & bS_HALT) {
      wOS_Write(pV, aSWCtrl, (vSWCtrl & 0xff) | bClrRun);
      C = 0; // return
    } else C--;
  } while (C);

}

void BreakARM(u32 * pV, u32 * pL)
{
  u32 TryTimes;
  u32 DATA    ;

  if (vErr) return;

  // break ARM       C_HALT = 1, C_DEBUGEN = 1
  DBG_Write(pV, pL, aDHCSR, bDBGKEY + bC_DEBUGEN + bC_HALT);  

  TryTimes = WaitTimes; 
  do {
    DATA = DBG_Read(pV, pL, aDHCSR);
    TryTimes--;
  } while ( ( (DATA & bS_HALT) == 0 ) && (TryTimes) );
  vaDHCSR = DATA;

}

u32 GetEnv(u32 * pV, u32 * pL)
{
  if (vErr) return(0);

  // break ARM       C_HALT = 1, C_DEBUGEN = 1
  DBG_Write(pV, pL, aDHCSR, bDBGKEY + bC_DEBUGEN + bC_HALT);  
  vaDHCSR = DBG_Read(pV, pL, aDHCSR);

  // wd8,00	 write SELECT
  Write32(pV, 0);
  wOS_Write(pV, aSWCMD, bA3);

  // wa0, 0x23000012  write a_CSW    Prot = 0x23, Increment single, size = 32 bits
  Write32(pV, (vaCSW & 0xFFFFFF00) | 0x12);
  wOS_Write(pV, aSWCMD, bAPnDP);

  // TAR = aDHCSR 
  Write32(pV, aDHCSR);
  wOS_Write(pV, aSWCMD, bAPnDP + bA2);

  // wd8,10	 write SELECT
  Write32(pV, 0x10);
  wOS_Write(pV, aSWCMD, bA3);

  // REG nn          // wa4  write a_BD1                   // ra8  read a_BD2                           // rdc   read d_RDBUFF
  Write32(pV, 0x00); wOS_Write(pV, aSWCMD, bAPnDP + bA2);  wOS_Write(pV, aSWCMD, bAPnDP + bRnW + bA3);  wOS_Write(pV, aSWCMD, bRnW + bA2 + bA3 + bREAD);

  // wd8, 0	 write SELECT
  Write32(pV, 0);
  wOS_Write(pV, aSWCMD, bA3);

  return(Read32(pV));
  
}

void SetEnv(u32* pV, u32 * pL, u32 R0, u32 R1, u32 R2, u32 R3, u32 vProc)
{
  if (vErr) return;

  // wd8,00	 write SELECT
  Write32(pV, 0);
  wOS_Write(pV, aSWCMD, bA3);

  // wa0, 0x23000012  write a_CSW    Prot = 0x23, Increment single, size = 32 bits
  Write32(pV, (vaCSW & 0xFFFFFF00) | 0x12);
  wOS_Write(pV, aSWCMD, bAPnDP);

  // TAR = aDHCSR 
  Write32(pV, aDHCSR);
  wOS_Write(pV, aSWCMD, bAPnDP + bA2);

  // wd8,10	 write SELECT
  Write32(pV, 0x10);
  wOS_Write(pV, aSWCMD, bA3);

  // REG nn value                  // wa8  write a_BD2                   // REG nn              // wa4  write a_BD1	
  Write32(pV, R0                ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x10000);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  
  Write32(pV, R1                ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x10001);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  
  Write32(pV, R2                ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x10002);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  
  Write32(pV, R3                ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x10003);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  

  Write32(pV, vLocalVar         ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x10009);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  
  Write32(pV, vFree             ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x1000D);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  
  Write32(pV, (vBreakpoint | 1) ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x1000E);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  
  Write32(pV, vProc             ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x1000F);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  
  Write32(pV, 0x01000000        ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x10010);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  
  Write32(pV, vFree             ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x10011);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  
  Write32(pV, vFree             ); wOS_Write(pV, aSWCMD, bAPnDP + bA3);  Write32(pV, 0x10012);  wOS_Write(pV, aSWCMD, bAPnDP + bA2);  

  // wd8, 0	 write SELECT
  Write32(pV, 0);
  wOS_Write(pV, aSWCMD, bA3);

}

// Cnt ܴ JM3FIFOSize
void WriteData(u32 * pV, u32 * pL, u32 Adr, u32 Cnt, u32 * pD)
{
  u32 TryTimes;
  u32 i       ;
  u8  b       ;

  if (vErr) return;

  i = Cnt;
  TryTimes = WaitTimes; 

  // TAR = Adr 
  Write32(pV, Adr); Adr += i << 2;
  wOS_Write(pV, aSWCMD, bAPnDP + bA2);

  while (i--) {
    Write32(pV, *pD++); 
    // wac      Write a_DRW
	  wOS_Write(pV, aSWCMD, bAPnDP + bA2 + bA3);
	}
	
	// wait all command send out
  do {
    b = wOS_Read(pV, aSWCtrl);
  } while ( ( (b & (bCEmpty +  bERROR)) == 0) && (--TryTimes) );

}
*/

// Cnt ܴ JM3FIFOSize
void ReadData(u32 * pV, u32 * pL, u32 Adr, u32 Cnt, u32 * pD)
{
  u32 i;
  u32 r;

  if (vErr) return;

  // backup read counter
  r = Cnt;
  i = Cnt;

  // TAR = Adr 
  Write32(pV, Adr); Adr += i << 2;
  wOS_Write(pV, aSWCMD, bAPnDP + bA2);

  // rac  read a_DRW							       
  wOS_Write(pV, aSWCMD, bAPnDP + bRnW + bA2 + bA3);

  while (i--) {
    if (i) { // not last word
	    // rac read a_DRW 
      wOS_Write(pV, aSWCMD, bAPnDP + bRnW + bA2 + bA3 + bREAD);
    } else { // last word
      // rdc read d_RDBUFF
      wOS_Write(pV, aSWCMD, bRnW + bA2 + bA3 + bREAD);
    }
  }

  while (r--) {
    *pD++	= Read32(pV);
  }
	
}

// SWD===========================================================================

// pV: ȫֱָ   pL: ֲָ   vPos: pBEFORE, pAFTER   vOption: ̶
u32 Run(u32 * pV, u32 * pL, u32 vPos, u32 vOption)
{
  if ( vOption == bPGNull ) {   // ̿ʼʱ̳ Run(pV, pL, pBEFORE, bPGNull)
    eVP  = 1         ;   //  Memory 

    CVPB = 0x08002F00;   // Memory ʼַ
    CVPE = 0x08002F0F;   // Memory ַ
                         // ܹ: 12 + 4 ֽ
  } else if ( (vPos == pBEFORE) && (vOption == bPGUnProtect) ) {     // ڿʼǰ(UnProtectǵһѡ) UCID, IDCODE
    ReadData(pV, pL, 0x1FFFF7E8, 3, &vUniqueID0_3);  // 3 words = 12 bytes
    vdIDCODE = DBG_Read(pV, pL, 0xE0042000);
  }

  return(0);
}

// ̳Ҫ AdrB..AdrE ʱ Memory
// pV: ȫֱָ   pL: ֲָ   pBuffer: ָ  AdrB: ʼַ   AdrE: ַ
u32 Memory(u32 * pV, u32 * pL, u8 * pBuffer, u32 AdrB, u32 AdrE)
{
  u32 i;
  u8 * pR;

  // ȷ 12 ֽڵ UCID
  pR = (u8 *) &vUniqueID0_3;
  for (i=0; i<12; i++) *pBuffer++ = *pR++;
  
  // ٷ 4 ֽڵ IDCODE
  pR = (u8 *) &vdIDCODE;
  for (i=0; i< 4; i++) *pBuffer++ = *pR++;
   
  return(0);
}
