
// ñе UART ͡
//  4 ֽ 0x78,0x56,0x34,0x12, 100ms, 
// ٷ 4 ֽ 0,0,0,0, 100ms,
// Ȼȴ, յٷͳȥûյͷһ0x55
// ʹȫֱĺҪ pV ʹþֲĺҪ pL 

#include "../INC/JM3_DEF.H"        
#include "../INC/JM3_VAR.H"
#include "../INC/JM3_UART.H"
#include "../INC/XMC4000.H"

struct PluginType const vPlugin = {
  0xFFFF0026,                // ID
  "XMC4000 UART Plugin",     // ID Description
};


#define vUartCtrl       (*(pL+0))
#define vUartData       (*(pL+1))
#define vUartStatus     (*(pL+2))

void InitUART(u32 * pV, u32 * pL)
{  
  // ò
  wOS_Write(pV, aUartBaudrate, (cbr9600 >> 8) & 0xFF);
  wOS_Write(pV, aUartBaudrate, (cbr9600 >> 8) & 0xFF);
  wOS_Write(pV, aUartBaudrate, cbr9600 & 0xFF);
  wOS_Write(pV, aUartBaudrate, cbr9600 & 0xFF);

  // λ UART
  vUartCtrl = bUartReset;
  wOS_Write(pV, aUartCtrl, vUartCtrl);  
  vUartCtrl &= (~bUartReset);

  // ȴ UART 
  wOS_Sleep(pV, 2); 
}


void TestUART(u32 * pV, u32 * pL)
{
  // 򿪵Դرշ
  vPowerCtrl = bPowerVIO;  
  wOS_Write(pV, aPowerCtrl, vPowerCtrl);

  // ȴԴ
  wOS_Sleep(pV, 100);

  vIOCtrl = bDEVEN;      // ʹӲ UART
  vIOData = 0;
  wOS_Write(pV, aIOData, vIOData);
  wOS_Write(pV, aIOCtrl, vIOCtrl);

  //  4 ֽ 
  wOS_Write(pV, aUartData, 0x78);
  wOS_Write(pV, aUartData, 0x56);
  wOS_Write(pV, aUartData, 0x34);
  wOS_Write(pV, aUartData, 0x12);
  // ȴ
  wOS_Wait (pV, 100, ( (aUartStatus << 16) + (bUartTEmpty << 8) + bUartTEmpty)); 
  //  100ms
  wOS_Sleep(pV, 100);

  //  4 ֽ 
  wOS_Write(pV, aUartData, 0);
  wOS_Write(pV, aUartData, 0);
  wOS_Write(pV, aUartData, 0);
  wOS_Write(pV, aUartData, 0);
  // ȴ
  wOS_Wait (pV, 100, ( (aUartStatus << 16) + (bUartTEmpty << 8) + bUartTEmpty)); 
  //  100ms
  wOS_Sleep(pV, 100);

  // ȴյ
  if (wOS_Wait(pV, 100, ( (aUartStatus << 16) + (bUartREmpty << 8) + 0)) ) {
    // 100ms ûյ,  0x55
    wOS_Write(pV, aUartData, 0x55);
  } else {
    // յ
    do {
      // ȡ
      vUartData = wOS_Read(pV, aUartData);
      // 
      wOS_Write(pV, aUartData, vUartData);
      // ȡ UART ״̬
      vUartStatus = wOS_Read(pV, aUartStatus);
     //  FIFO лݼش 
   } while ( (vUartStatus & bUartREmpty) == 0 );
 
  }

  wOS_Sleep(pV, 100);

}

// pV: ȫֱָ   pL: ֲָ   vPos: pBEFORE, pAFTER   vOption: ̶
u32 Run(u32 * pV, u32 * pL, u32 vPos, u32 vOption)
{
  if ( (vPos == pBEFORE) && (vOption == bPGConnect) ) { // (Connect)ǰ UART
    InitUART(pV, pL);
    TestUART(pV, pL);
  }

  return(0);
}
