﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApp1
{
    class JM3
    {
        // 状态信息定义
        public const UInt32 OK = 0;  // 运行正常，没有错误

        // 下面1-10 为编程器上电自检错误信息
        public const UInt32 ERROR_MONI = 1;  // 编程器监控程序错误
        public const UInt32 ERROR_ALGO = 2;  // 编程器编程算法错误
        public const UInt32 ERROR_RTC = 3;  // 编程器中的实时时钟错误，通常是电池没电了
        public const UInt32 ERROR_FLASH_FORMAT = 4;  // 内部FLASH 格式错误，需要重新格式化
        public const UInt32 ERROR_FLASH_TF = 5;  // TF 卡错误
        public const UInt32 ERROR_FPGA_ID = 6;  // 编程器中的FPGA ID 错误
        public const UInt32 ERROR_FPGA_CFG = 7;  // 编程器中的FPGA 配置错误
        public const UInt32 ERROR_FPGA_IP = 8;  // 编程器中的FPGA IP 码错误
        public const UInt32 ERROR_FLASH_ID = 9;  // 编程器中的FLASH ID 错误
        public const UInt32 ERROR_FLASH_CFG = 10; // 编程器中的FLASH 配置错误

        // 下面20-24 为打开JMO 的错误信息
        public const UInt32 ERROR_CHIPTYPE = 20; // 芯片类型错误
        public const UInt32 ERROR_PROGID = 21; // JMO 限定了编程器编号，当前编程序器编号不在允许列表中
        public const UInt32 ERROR_COUNTER = 22; // JMO 限定了编程记数, 现在剩余编程记数为0
        public const UInt32 ERROR_AES = 23; // JMO 设定了加密，现在编程器中的密码不对
        public const UInt32 ERROR_CHKSUM = 24; // JMO 的CHKSUM 不对

        // 下面31-63 为编程器当前的工作状态
        public const UInt32 PROG_NULL = 31; // 编程器空闲
        public const UInt32 PROG_WAIT_KEY = 32; // 编程器在等待用户按键启动编程
        public const UInt32 PROG_AUTO = 33; // 编程器在等待用户连接芯片
        public const UInt32 PROG_TEST_PIN = 34; // 编程器在编程完毕，用户可以用plugin 程序测试芯片
        public const UInt32 PROG_CONNECT = 35; // 编程器在连接芯片
        public const UInt32 PROG_RESTORE = 36; // 编程器在恢复芯片
        public const UInt32 PROG_ERASE = 37; // 编程器在擦除芯片
        public const UInt32 PROG_WRITE = 38; // 编程器在编程芯片
        public const UInt32 PROG_READ = 39; // 编程器在读芯片
        public const UInt32 PROG_VERIFY = 40; // 编程器在校验芯片
        public const UInt32 PROG_PROTECT = 41; // 编程器在编程加密信息
        public const UInt32 PROG_UNPROTECT = 42; // 编程器在解除芯片加密
        public const UInt32 PROG_BLANKCHECK = 43; // 编程器在做空片检查
        public const UInt32 PROG_CTRL = 44; // 编程器在CTRL
        public const UInt32 PROG_EPROM = 45; // 编程器在编程EPROM 或OTP
        public const UInt32 PROG_BOOTLOAD = 46; // 编程器在编程BOOTLOAD
        public const UInt32 PROG_ATE = 47; // 编程器在等待ATE 接口的START 信号
        public const UInt32 PROG_SVF = 48; // 下面48-57 用于JTAG 口编程
        public const UInt32 PROG_IDCODE = 49; // 编程器在执行IDCODE
        public const UInt32 PROG_CHECK_OPT = 50; // 编程器在执行CHECK_OPT
        public const UInt32 PROG_PIO = 51; // 编程器在执行PIO
        public const UInt32 PROG_WRITE_OPT = 52; // 编程器在执行WRITE_OPT
        public const UInt32 PROG_READ_OPT = 53; // 编程器在执行READ_OPT
        public const UInt32 PROG_TEST = 54; // 编程器在执行TEST
        public const UInt32 PROG_USER_ID0 = 55; // 编程器在执行USER_ID0
        public const UInt32 PROG_USER_ID1 = 56; // 编程器在执行USER_ID1
        public const UInt32 PROG_USER_ID2 = 57; // 编程器在执行USER_ID2
        public const UInt32 PROG_EXECUTE = 58; // 编程器在运行芯片中的程序
        public const UInt32 PROG_JMO_NO = 59; // 编程器在执行多JMO 合并中的一个JMO
        public const UInt32 PROG_DOWNLOAD = 60; // 编程器在下载编程程序
        public const UInt32 PROG_POWERON = 61; // 编程器在上电
        public const UInt32 PROG_POWEROFF = 62; // 编程器在下电
        public const UInt32 PROG_FINISH = 63; // 编程器完成工作

        // 70-79 是命令执行过程中的错误信息
        public const UInt32 ERROR_CONNECT = 70; // 连接编程器错误
        public const UInt32 ERROR_PARAMETER = 71; // 命令的参数不对
        public const UInt32 ERROR_FILE_NOT_FOUND = 72; // 文件未找到
        public const UInt32 ERROR_READ_FILE = 73; // 文件读错误
        public const UInt32 ERROR_WRITE_FILE = 74; // 文件写错误
        public const UInt32 ERROR_TOO_MANY_COMMAND = 75; // 命令行太多（最多1024 行，可以放在不同的文件中用CMD 命令调用）
        public const UInt32 ERROR_UNKNOWN_COMMAND = 76; // 命令错
        public const UInt32 ERROR_JMO_FILE = 77; // JMO 文件错
        public const UInt32 ERROR_JMO_DOWNLOAD = 78; // JMO 文件下载错
        public const UInt32 ERROR_UNKNOWN = 79; // 未知错误

        // 80-81 为编程器状态
        public const UInt32 MODE_MONITOR = 80; // 编程器在监控态
        public const UInt32 MODE_PROGRAM = 81; // 编程器在编程态

        // ATE 控制位定义
        public const UInt32 bBUSY = 1; // 编程器忙
        public const UInt32 bOK = 2; // 编程器编程成功
        public const UInt32 bNG = 4; // 编程器编程失败

        // JM3 相关函数定义
        [DllImport("JM_USB.dll", EntryPoint = "JM_VER", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_VER();

        [DllImport("JM_USB.dll", EntryPoint = "JM_BAUDRATE", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_BAUDRATE(UInt32 BAUDRATE);

        [DllImport("JM_USB.dll", EntryPoint = "JM_CLOSEJMO", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_CLOSEJMO(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_COUNTER", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_COUNTER(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_DELETE", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_DELETE(UInt32 JMNO, UInt32 N);

        [DllImport("JM_USB.dll", EntryPoint = "JM_DOWNLOAD", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_DOWNLOAD(UInt32 JMNO, UInt32 F, Byte[] p);

        [DllImport("JM_USB.dll", EntryPoint = "JM_EXIT", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_EXIT();

        [DllImport("JM_USB.dll", EntryPoint = "JM_FID", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_FID(UInt32 JMNO, UInt32 F, Byte[] p);

        [DllImport("JM_USB.dll", EntryPoint = "JM_FILE", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_FILE(UInt32 JMNO, UInt32 F);

        [DllImport("JM_USB.dll", EntryPoint = "JM_FORMAT", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_FORMAT(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_JM", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_JM(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_LASTERROR", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_LASTERROR(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_LOGOFF", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_LOGOFF();

        [DllImport("JM_USB.dll", EntryPoint = "JM_LOGON", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_LOGON(UInt32 M, Byte[] p);

        [DllImport("JM_USB.dll", EntryPoint = "JM_MESSAGE", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_MESSAGE(UInt32 JMNO, UInt32 P);

        [DllImport("JM_USB.dll", EntryPoint = "JM_MODE", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_MODE(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_NAME", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_NAME(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_OPENJMO", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_OPENJMO(UInt32 JMNO, UInt32 N);

        [DllImport("JM_USB.dll", EntryPoint = "JM_POWER", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_POWER(UInt32 JMNO, UInt32 P, UInt32 V);

        [DllImport("JM_USB.dll", EntryPoint = "JM_READIO", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_READIO(UInt32 JMNO, UInt32 P, UInt32 A);

        [DllImport("JM_USB.dll", EntryPoint = "JM_RESET", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_RESET(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_RUN", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_RUN(UInt32 JMNO, UInt32 P);

        [DllImport("JM_USB.dll", EntryPoint = "JM_SERIAL", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_SERIAL(UInt32 JMNO, UInt32 P, UInt32 L, Byte[] p);

        [DllImport("JM_USB.dll", EntryPoint = "JM_SETAUTOFILE", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_SETAUTOFILE(UInt32 JMNO, UInt32 N);

        [DllImport("JM_USB.dll", EntryPoint = "JM_SETNAME", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_SETNAME(UInt32 JMNO, Byte[] p);

        [DllImport("JM_USB.dll", EntryPoint = "JM_SETPASSWORD", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_SETPASSWORD(UInt32 JMNO, Byte[] p);

        [DllImport("JM_USB.dll", EntryPoint = "JM_SNO", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_SNO(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_START", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_START(UInt32 JMNO, UInt32 P);

        [DllImport("JM_USB.dll", EntryPoint = "JM_VERSION", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_VERSION(UInt32 JMNO);

        [DllImport("JM_USB.dll", EntryPoint = "JM_WRITEIO", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_WRITEIO(UInt32 JMNO, UInt32 P, UInt32 A, UInt32 D);

        [DllImport("JM_USB.dll", EntryPoint = "JM_WRITELOG", CallingConvention = CallingConvention.Cdecl)]
        public static extern UInt32 JM_WRITELOG(Byte[] p);
    }
}

namespace WindowsFormsApp1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

//        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256, ArraySubType = UnmanagedType.I1)]
//        public Byte[] BBUF;

        private void button1_Click(object sender, EventArgs e)
        {
            unsafe
            {
                UInt32 JMN;
                String FN = "KF32.JMO";
                String NFN = "C:\\ABC.JMO";
                String RFN = "ABC.JMO";
                UInt32 FNO;
                Byte[] BBUF;
                Byte[] RBUF = new byte[256]; 
                UInt32 I;
                Byte* P;
                UInt32 F;

                JMN = JM3.JM_JM(0);
                JM3.JM_CLOSEJMO(0);

                // JM_USB.DLL的字符串类型是一个指向字节数组的指针，这个数组中包含了字符串及一个0做为字符串结束标识，所以在用System.Text.Encoding.ASCII.GetBytes换转时要在最后加上一个0
                BBUF = System.Text.Encoding.ASCII.GetBytes(NFN + (char)0);
                FNO = JM3.JM_FID(1, 0, BBUF);  // 如果 FNO != 0 表示要下载的文件编程器中有存在
                I = JM3.JM_DOWNLOAD(1, 0, BBUF); // 下载JMO，I表示是否下载成功
                BBUF = System.Text.Encoding.ASCII.GetBytes(RFN + (char)0); 
                FNO = JM3.JM_FID(1, 0, BBUF);   // 取下载JMO的顺序号

                BBUF = System.Text.Encoding.ASCII.GetBytes(FN + (char)0);  // 取另一个JMO的顺序号
                FNO = JM3.JM_FID(1, 0, BBUF);
             
                // 下面的程序将返回的字符串放在一个字符数组中
                P = (Byte*)JM3.JM_FILE(1, FNO);
                I = 1;
                do
                {
                    RBUF[I] = *P;
                    if (*P == 0) F = 1; else F = 0;  // 0 
                    I++;
                    P++;
                } while (F == 0);
                   
                JM3.JM_OPENJMO(1, 1);
                JM3.JM_RUN(1, 0);
            }
        }
    }
}
