
#include "vcl.h"
#include "stdio.h"
#include "conio.h"
#include "JM_USB.h"

#pragma hdrstop
#pragma nopackwarning


char ICTypeStr[16];
char RES_STR[24];
u32 JMNO,FileNO;

extern "C"
{
/*
function JMU_BAUDRATE(BAUDRATE: u32)                      : u32    ; cdecl; external DLLU_NAME name 'JM_BAUDRATE'   ;
function JMU_CLOSEJMO(JMNO: u32)                          : u32    ; cdecl; external DLLU_NAME name 'JM_CLOSEJMO'   ;
function JMU_COUNTER(JMNO: u32)                           : u32    ; cdecl; external DLLU_NAME name 'JM_COUNTER'    ;
function JMU_DELETE(JMNO: u32; N: u32)                    : u32    ; cdecl; external DLLU_NAME name 'JM_DELETE'     ;
function JMU_DOWNLOAD(JMNO: u32; F: u32; p: pointer)      : u32    ; cdecl; external DLLU_NAME name 'JM_DOWNLOAD'   ;
function JMU_EXIT                                         : u32    ; cdecl; external DLLU_NAME name 'JM_EXIT'       ;
function JMU_FID(JMNO: u32; F: u32; p: pointer)           : u32    ; cdecl; external DLLU_NAME name 'JM_FID'        ;
function JMU_FILE(JMNO: u32; F: u32)                      : pointer; cdecl; external DLLU_NAME name 'JM_FILE'       ;
function JMU_FORMAT(JMNO: u32)                            : u32    ; cdecl; external DLLU_NAME name 'JM_FORMAT'     ;
function JMU_JM(JMNO: u32)                                : u32    ; cdecl; external DLLU_NAME name 'JM_JM'         ;
function JMU_LASTERROR(JMNO: u32)                         : u32    ; cdecl; external DLLU_NAME name 'JM_LASTERROR'  ;
function JMU_LOGOFF                                       : u32    ; cdecl; external DLLU_NAME name 'JM_LOGOFF'     ;
function JMU_LOGON(M: u32; p: pointer)                    : u32    ; cdecl; external DLLU_NAME name 'JM_LOGON'      ;
function JMU_MESSAGE(JMNO: u32; P: u32)                   : u32    ; cdecl; external DLLU_NAME name 'JM_MESSAGE'    ;
function JMU_MODE(JMNO: u32)                              : u32    ; cdecl; external DLLU_NAME name 'JM_MODE'       ;
function JMU_NAME(JMNO: u32)                              : pointer; cdecl; external DLLU_NAME name 'JM_NAME'       ;
function JMU_OPENJMO(JMNO: u32; N: u32)                   : u32    ; cdecl; external DLLU_NAME name 'JM_OPENJMO'    ;
function JMU_POWER(JMNO: u32; P: u32; V: u32)             : u32    ; cdecl; external DLLU_NAME name 'JM_POWER'      ;
function JMU_READIO(JMNO: u32; P: u32; A: u32)            : u32    ; cdecl; external DLLU_NAME name 'JM_READIO'     ;
function JMU_RESET(JMNO: u32)                             : u32    ; cdecl; external DLLU_NAME name 'JM_RESET'      ;
function JMU_RUN(JMNO: u32; P: u32)                       : u32    ; cdecl; external DLLU_NAME name 'JM_RUN'        ;
function JMU_SERIAL(JMNO: u32; P: u32; L: u32; s: pointer): u32    ; cdecl; external DLLU_NAME name 'JM_SERIAL'     ;
function JMU_SETAUTOFILE(JMNO: u32; N: u32)               : u32    ; cdecl; external DLLU_NAME name 'JM_SETAUTOFILE';
function JMU_SETNAME(JMNO: u32; p: pointer)               : u32    ; cdecl; external DLLU_NAME name 'JM_SETNAME'    ;
function JMU_SETPASSWORD(JMNO: u32; p: pointer)           : u32    ; cdecl; external DLLU_NAME name 'JM_SETPASSWORD';
function JMU_SNO(JMNO: u32)                               : u32    ; cdecl; external DLLU_NAME name 'JM_SNO'        ;
function JMU_START(JMNO: u32; P: u32)                     : u32    ; cdecl; external DLLU_NAME name 'JM_START'      ;
function JMU_VERSION(JMNO: u32)                           : u32    ; cdecl; external DLLU_NAME name 'JM_VERSION'    ;
function JMU_WRITEIO(JMNO: u32; P: u32; A: u32; D: u32)   : u32    ; cdecl; external DLLU_NAME name 'JM_WRITEIO'    ;
function JMU_WRITELOG(p: pointer)                         : u32    ; cdecl; external DLLU_NAME name 'JM_WRITELOG'   ;

*/
    typedef int (* DLLBAUDRATE)( u32 U);
    DLLBAUDRATE myBAUDRATE=0,myBAUDRATEu=0,myBAUDRATEc=0;
    typedef int (* DLLCLOSEJMO)( u32 U);
    DLLCLOSEJMO myCLOSEJMO=0, myCLOSEJMOu=0,myCLOSEJMOc=0;
    typedef int (* DLLCOUNTER)( u32 U);
    DLLCOUNTER myCOUNTER=0,myCOUNTERu=0,myCOUNTERc=0;
    typedef int (* DLLDELETE)( u32 U,u32 N);
    DLLDELETE myDELETE=0,myDELETEu=0,myDELETEc=0;
    typedef int (* DLLDOWNLOAD)( u32 U,u32 F,int * p);
    DLLDOWNLOAD myDOWNLOAD=0,myDOWNLOADu=0,myDOWNLOADc=0;
    typedef int (* DLLEXIT)(void);
    DLLEXIT myEXIT=0,myEXITu=0,myEXITc=0;
    typedef int (* DLLFID)( u32 U,u32 F,int * p);
    DLLFID myFID=0,myFIDu=0,myFIDc=0;
    typedef  * (* DLLFILE)( u32 U,u32 N);     //pointer
    DLLFILE myFILE=0,myFILEu=0,myFILEc=0;
    typedef int (* DLLFORMAT)( u32 U);
    DLLFORMAT myFORMAT=0,myFORMATu=0,myFORMATc=0;
    typedef int (* DLLJM)( u32 U);
    DLLJM myJM=0,myJMu=0,myJMc=0;
    typedef int (* DLLLASTERROR)( u32 U);
    DLLLASTERROR myLASTERROR=0,myLASTERRORu=0,myLASTERRORc=0;
    typedef int (* DLLLOGOFF)(void);
    DLLLOGOFF myLOGOFF=0,myLOGOFFu=0,myLOGOFFc=0;
    typedef int (* DLLLOGON)( u32 U,int * p);
    DLLLOGON myLOGON=0,myLOGONu=0,myLOGONc=0;
    typedef int (* DLLMESSAGE)( u32 U,u32 N);
    DLLMESSAGE myMESSAGE=0,myMESSAGEu=0,myMESSAGEc=0;
    typedef int (* DLLMODE)( u32 U);
    DLLMODE myMODE=0, myMODEu=0,myMODEc=0;
    typedef  * (* DLLNAME)( u32 U);     //pointer
    DLLNAME myNAME=0,myNAMEu=0,myNAMEc=0;
    typedef int (* DLLOPENJMO)( u32 U,u32 N);
    DLLOPENJMO myOPENJMO=0,myOPENJMOu=0,myOPENJMOc=0;
    typedef int (* DLLPOWER)( u32 U,u32 N,u32 V);
    DLLPOWER myPOWER=0,myPOWERu=0,myPOWERc=0;
    typedef int (* DLLREADIO)( u32 U,u32 N,u32 A);
    DLLREADIO myREADIO=0,myREADIOu=0,myREADIOc=0;
    typedef int (* DLLRESET)( u32 U);
    DLLRESET myRESET=0,myRESETu=0,myRESETc=0;
    typedef int (* DLLRUN)( u32 U,u32 N);
    DLLRUN myRUN=0,myRUNu=0,myRUNc=0;
    typedef int (* DLLSERIAL)( u32 U,u32 P,u32 L,int * p);
    DLLSERIAL mySERIAL=0,mySERIALu=0,mySERIALc=0;
    typedef int (* DLLSETAUTOFILE)( u32 U,u32 N);
    DLLSETAUTOFILE mySETAUTOFILE=0,mySETAUTOFILEu=0,mySETAUTOFILEc=0;
    typedef int (* DLLSETNAME)( u32 U,int * p);
    DLLSETNAME mySETNAME=0,mySETNAMEu=0,mySETNAMEc=0;
    typedef int (* DLLSETPASSWORD)( u32 U,int * p);
    DLLSETPASSWORD mySETPASSWORD=0,mySETPASSWORDu=0,mySETPASSWORDc=0;
    typedef int (* DLLSNO)( u32 U);
    DLLSNO mySNO=0,mySNOu=0,mySNOc=0;
    typedef int (* DLLSTART)( u32 U,u32 N);
    DLLSTART mySTART=0,mySTARTu=0,mySTARTc=0;
    typedef int (* DLLVERSION)( u32 U);
    DLLVERSION myVERSION=0,myVERSIONu=0,myVERSIONc=0;
    typedef int (* DLLWRITEIO)( u32 U,u32 P,u32 L,u32 D);
    DLLWRITEIO myWRITEIO=0,myWRITEIOu=0,myWRITEIOc=0;
    typedef int (* DLLWRITELOG)( int * p);
    DLLWRITELOG myWRITELOG=0,myWRITELOGu=0,myWRITELOGc=0;

}

#pragma argsused
//USB ӷʽDLL
int InitDLLu(HINSTANCE hD)
{
  myBAUDRATEu = (DLLBAUDRATE)GetProcAddress(hD,"JM_BAUDRATE");
  if(!myBAUDRATEu) return -1;
  myCLOSEJMOu = (DLLCLOSEJMO)GetProcAddress(hD,"JM_CLOSEJMO");
  if(!myCLOSEJMOu) return -1;
  myCOUNTERu = (DLLCOUNTER)GetProcAddress(hD,"JM_COUNTER");
  if(!myCOUNTERu) return -1;
  myDELETEu = (DLLDELETE)GetProcAddress(hD,"JM_DELETE");
  if(!myDELETEu) return -1;
  myDOWNLOADu = (DLLDOWNLOAD)GetProcAddress(hD,"JM_DOWNLOAD");
  if(!myDOWNLOADu) return -1;
  myEXITu = (DLLEXIT)GetProcAddress(hD,"JM_EXIT");
  if(!myEXITu) return -1;
  myFIDu = (DLLFID)GetProcAddress(hD,"JM_FID");
  if(!myFIDu) return -1;
  myFILEu = (DLLFILE)GetProcAddress(hD,"JM_FILE");
  if(!myFILEu) return -1;
  myFORMATu = (DLLFORMAT)GetProcAddress(hD,"JM_FORMAT");
  if(!myFORMATu) return -1;
  myJMu = (DLLJM)GetProcAddress(hD,"JM_JM");
  if(!myJMu) return -1;
  myLASTERRORu = (DLLLASTERROR)GetProcAddress(hD,"JM_LASTERROR");
  if(!myLASTERRORu) return -1;
  myLOGOFFu = (DLLLOGOFF)GetProcAddress(hD,"JM_LOGOFF");
  if(!myLOGOFFu) return -1;
  myLOGONu = (DLLLOGON)GetProcAddress(hD,"JM_LOGON");
  if(!myLOGONu) return -1;
  myMESSAGEu = (DLLMESSAGE)GetProcAddress(hD,"JM_MESSAGE");
  if(!myMESSAGEu) return -1;
  myMODEu = (DLLMODE)GetProcAddress(hD,"JM_MODE");
  if(!myMODEu) return -1;
  myNAMEu = (DLLNAME)GetProcAddress(hD,"JM_NAME");
  if(!myNAMEu) return -1;
  myOPENJMOu = (DLLOPENJMO)GetProcAddress(hD,"JM_OPENJMO");
  if(!myOPENJMOu) return -1;
  myPOWERu = (DLLPOWER)GetProcAddress(hD,"JM_POWER");
  if(!myPOWERu) return -1;
  myREADIOu = (DLLREADIO)GetProcAddress(hD,"JM_READIO");
  if(!myREADIOu) return -1;
  myRESETu = (DLLRESET)GetProcAddress(hD,"JM_RESET");
  if(!myRESETu) return -1;
  myRUNu = (DLLRUN)GetProcAddress(hD,"JM_RUN");
  if(!myRUNu) return -1;
  mySERIALu = (DLLSERIAL)GetProcAddress(hD,"JM_SERIAL");
  if(!mySERIALu) return -1;
  mySETAUTOFILEu  = (DLLSETAUTOFILE )GetProcAddress(hD,"JM_SETAUTOFILE");
  if(!mySETAUTOFILEu ) return -1;
  mySETNAMEu = (DLLSETNAME)GetProcAddress(hD,"JM_SETNAME");
  if(!mySETNAMEu) return -1;
  mySETPASSWORDu = (DLLSETPASSWORD)GetProcAddress(hD,"JM_SETPASSWORD");
  if(!mySETPASSWORDu) return -1;
  mySNOu = (DLLSNO)GetProcAddress(hD,"JM_SNO");
  if(!mySNOu) return -1;
  mySTARTu = (DLLSTART)GetProcAddress(hD,"JM_START");
  if(!mySTARTu) return -1;
  myVERSIONu = (DLLVERSION)GetProcAddress(hD,"JM_VERSION");
  if(!myVERSIONu) return -1;
  myWRITEIOu = (DLLWRITEIO)GetProcAddress(hD,"JM_WRITEIO");
  if(!myWRITEIOu) return -1;
  myWRITELOGu = (DLLWRITELOG)GetProcAddress(hD,"JM_WRITELOG");
  if(!myWRITELOGu) return -1;

  return 0;
}

//COM ӷʽDLLUSBӷʽһֻǴDLLļINSTANCEͬ
int InitDLLc(HINSTANCE hD)
{
  myBAUDRATEc = (DLLBAUDRATE)GetProcAddress(hD,"JM_BAUDRATE");
  if(!myBAUDRATEc) return -1;
  myCLOSEJMOc = (DLLCLOSEJMO)GetProcAddress(hD,"JM_CLOSEJMO");
  if(!myCLOSEJMOc) return -1;
  myCOUNTERc = (DLLCOUNTER)GetProcAddress(hD,"JM_COUNTER");
  if(!myCOUNTERc) return -1;
  myDELETEc = (DLLDELETE)GetProcAddress(hD,"JM_DELETE");
  if(!myDELETEc) return -1;
  myDOWNLOADc = (DLLDOWNLOAD)GetProcAddress(hD,"JM_DOWNLOAD");
  if(!myDOWNLOADc) return -1;
  myEXITc = (DLLEXIT)GetProcAddress(hD,"JM_EXIT");
  if(!myEXITc) return -1;
  myFIDc = (DLLFID)GetProcAddress(hD,"JM_FID");
  if(!myFIDc) return -1;
  myFILEc = (DLLFILE)GetProcAddress(hD,"JM_FILE");
  if(!myFILEc) return -1;
  myFORMATc = (DLLFORMAT)GetProcAddress(hD,"JM_FORMAT");
  if(!myFORMATc) return -1;
  myJMc = (DLLJM)GetProcAddress(hD,"JM_JM");
  if(!myJMc) return -1;
  myLASTERRORc = (DLLLASTERROR)GetProcAddress(hD,"JM_LASTERROR");
  if(!myLASTERRORc) return -1;
  myLOGOFFc = (DLLLOGOFF)GetProcAddress(hD,"JM_LOGOFF");
  if(!myLOGOFFc) return -1;
  myLOGONc = (DLLLOGON)GetProcAddress(hD,"JM_LOGON");
  if(!myLOGONc) return -1;
  myMESSAGEc = (DLLMESSAGE)GetProcAddress(hD,"JM_MESSAGE");
  if(!myMESSAGEc) return -1;
  myMODEc = (DLLMODE)GetProcAddress(hD,"JM_MODE");
  if(!myMODEc) return -1;
  myNAMEc = (DLLNAME)GetProcAddress(hD,"JM_NAME");
  if(!myNAMEc) return -1;
  myOPENJMOc = (DLLOPENJMO)GetProcAddress(hD,"JM_OPENJMO");
  if(!myOPENJMOc) return -1;
  myPOWERc = (DLLPOWER)GetProcAddress(hD,"JM_POWER");
  if(!myPOWERc) return -1;
  myREADIOc = (DLLREADIO)GetProcAddress(hD,"JM_READIO");
  if(!myREADIOc) return -1;
  myRESETc = (DLLRESET)GetProcAddress(hD,"JM_RESET");
  if(!myRESETc) return -1;
  myRUNc = (DLLRUN)GetProcAddress(hD,"JM_RUN");
  if(!myRUNc) return -1;
  mySERIALc = (DLLSERIAL)GetProcAddress(hD,"JM_SERIAL");
  if(!mySERIALc) return -1;
  mySETAUTOFILEc  = (DLLSETAUTOFILE )GetProcAddress(hD,"JM_SETAUTOFILE");
  if(!mySETAUTOFILEc ) return -1;
  mySETNAMEc = (DLLSETNAME)GetProcAddress(hD,"JM_SETNAME");
  if(!mySETNAMEc) return -1;
  mySETPASSWORDc = (DLLSETPASSWORD)GetProcAddress(hD,"JM_SETPASSWORD");
  if(!mySETPASSWORDc) return -1;
  mySNOc = (DLLSNO)GetProcAddress(hD,"JM_SNO");
  if(!mySNOc) return -1;
  mySTARTc = (DLLSTART)GetProcAddress(hD,"JM_START");
  if(!mySTARTc) return -1;
  myVERSIONc = (DLLVERSION)GetProcAddress(hD,"JM_VERSION");
  if(!myVERSIONc) return -1;
  myWRITEIOc = (DLLWRITEIO)GetProcAddress(hD,"JM_WRITEIO");
  if(!myWRITEIOc) return -1;
  myWRITELOGc = (DLLWRITELOG)GetProcAddress(hD,"JM_WRITELOG");
  if(!myWRITELOGc) return -1;

  return 0;
}

//оƬ
void ICType2Str( u32 ICType)
{
   switch (ICType){
    case IC_24       : sprintf(ICTypeStr,"%s","24xx");         break;
    case IC_25       : sprintf(ICTypeStr,"%s","25xx");         break;
    case IC_XMC1000  : sprintf(ICTypeStr,"%s","XMC1000-UART"); break;
    case IC_XMC1000W : sprintf(ICTypeStr,"%s","XMC1000-WISP"); break;
    case IC_XMC4000  : sprintf(ICTypeStr,"%s","XMC4000-UART"); break;
    case IC_XMC4000S : sprintf(ICTypeStr,"%s","XMC4000-SWD");  break;
    case IC_XMC4000W : sprintf(ICTypeStr,"%s","XMC4000-WISP"); break;
    case IC_XMC1XSX  : sprintf(ICTypeStr,"%s","XMC1xSx-UART"); break;
    case IC_XC800    : sprintf(ICTypeStr,"%s","XC800-UART");   break;
    case IC_XC800W   : sprintf(ICTypeStr,"%s","XC800-WISP");   break;
    case IC_TLE984X  : sprintf(ICTypeStr,"%s","TLE984X-LIN");  break;
    case IC_TLE986X7X: sprintf(ICTypeStr,"%s","TLE986X7X-LIN");break;
    case IC_TLE98XX  : sprintf(ICTypeStr,"%s","TLE98XX-SWD");  break;
    case IC_CORTEX_M : sprintf(ICTypeStr,"%s","CORTEX-M");     break;
    case IC_STM32    : sprintf(ICTypeStr,"%s","STM32-SWD");    break;
    case IC_STM32I   : sprintf(ICTypeStr,"%s","STM32-ISP");    break;
    case IC_STM32W   : sprintf(ICTypeStr,"%s","STM32-WISP");   break;
    case IC_NXPLPCM  : sprintf(ICTypeStr,"%s","NXPLPCM-SWD");  break;
    case IC_NXPLPCMI : sprintf(ICTypeStr,"%s","NXPLPCM-ISP");  break;
    case IC_NXPLPCMW : sprintf(ICTypeStr,"%s","NXPLPCM-WISP"); break;
    case IC_NUVOTON  : sprintf(ICTypeStr,"%s","NUVOTON-SWD");  break;
    case IC_NUVOTONI : sprintf(ICTypeStr,"%s","NUVOTON-ISP");  break;
    case IC_NUVOTONW : sprintf(ICTypeStr,"%s","NUVOTON-WISP"); break;
    case IC_AT89LP   : sprintf(ICTypeStr,"%s","AT89LP-SPI");   break;
    case IC_AT89LPI  : sprintf(ICTypeStr,"%s","AT89LP-ISP");   break;
    case IC_AT89LPW  : sprintf(ICTypeStr,"%s","AT89LP-WISP");  break;
    case IC_ME       : sprintf(ICTypeStr,"%s","ME9101");       break;
    case IC_JTAG_SVF : sprintf(ICTypeStr,"%s","JTAG_SVF");     break;
    case IC_ICSP8    : sprintf(ICTypeStr,"%s","PIC 8 bit");    break;
    case IC_GD32     : sprintf(ICTypeStr,"%s","GD32");         break;
    case IC_GD32I    : sprintf(ICTypeStr,"%s","GD32 ISP");     break;
    case IC_GD32W    : sprintf(ICTypeStr,"%s","GD32 WISP");    break;
    case IC_MM32     : sprintf(ICTypeStr,"%s","MM32");         break;
    case IC_MM32I    : sprintf(ICTypeStr,"%s","MM32 ISP");     break;
    case IC_MM32W    : sprintf(ICTypeStr,"%s","MM32 WISP");    break;
    case IC_LKS32    : sprintf(ICTypeStr,"%s","LK32");         break;
    case IC_LKS32I   : sprintf(ICTypeStr,"%s","LK32 ISP");     break;
    case IC_LKS32W   : sprintf(ICTypeStr,"%s","LK32 WISP");    break;
    case IC_RENESAS_RX200  : sprintf(ICTypeStr,"%s","RENESAS R200 FN");     break;
    case IC_RENESAS_RX200I : sprintf(ICTypeStr,"%s","RENESAS R200 ISP");    break;
    case IC_RENESAS_RX200W : sprintf(ICTypeStr,"%s","RENESAS R200 WIS");    break;

    default          : sprintf(ICTypeStr,"%s","UNDEFINE");     break;
  };
};

//Ϣ
void RES2STR(u32 R)
{
    switch ( R ){
      case OK                     :sprintf(RES_STR,"%s","OK"                 );break;
      case ERROR_MONI             :sprintf(RES_STR,"%s","ERROR_MONI"         );break;
      case ERROR_ALGO             :sprintf(RES_STR,"%s","ERROR_ALGO"         );break;
      case ERROR_RTC              :sprintf(RES_STR,"%s","ERROR_RTC"          );break;
      case ERROR_FLASH_FORMAT     :sprintf(RES_STR,"%s","ERROR_FLASH_FORMAT" );break;
      case ERROR_FLASH_TF         :sprintf(RES_STR,"%s","ERROR_FLASH_TF"     );break;
      case ERROR_FPGA_ID	  :sprintf(RES_STR,"%s","ERROR_FPGA_ID"      );break;
      case ERROR_FPGA_CFG         :sprintf(RES_STR,"%s","ERROR_FPGA_CFG"     );break;
      case ERROR_FPGA_IP          :sprintf(RES_STR,"%s","ERROR_FPGA_IP"      );break;
      case ERROR_FLASH_ID         :sprintf(RES_STR,"%s","ERROR_FLASH_ID"     );break;
      case ERROR_FLASH_CFG        :sprintf(RES_STR,"%s","ERROR_FLASH_CFG"    );break;

      case ERROR_CHIPTYPE         :sprintf(RES_STR,"%s","ERROR_CHIPTYPE"     );break;
      case ERROR_PROGID           :sprintf(RES_STR,"%s","ERROR_PROGID"       );break;
      case ERROR_COUNTER          :sprintf(RES_STR,"%s","ERROR_COUNTER"      );break;
      case ERROR_AES              :sprintf(RES_STR,"%s","ERROR_AES"          );break;
      case ERROR_CHKSUM           :sprintf(RES_STR,"%s","ERROR_CHKSUM"       );break;

      case PROG_NULL              :sprintf(RES_STR,"%s","PROG_NULL"          );break;
      case PROG_WAIT_KEY          :sprintf(RES_STR,"%s","PROG_WAIT_KEY"      );break;
      case PROG_AUTO              :sprintf(RES_STR,"%s","PROG_AUTO"          );break;
      case PROG_TEST_PIN          :sprintf(RES_STR,"%s","PROG_TEST_PIN"      );break;
      case PROG_CONNECT           :sprintf(RES_STR,"%s","PROG_CONNECT"       );break;
      case PROG_RESTORE           :sprintf(RES_STR,"%s","PROG_RESTORE"       );break;
      case PROG_ERASE             :sprintf(RES_STR,"%s","PROG_ERASE"         );break;
      case PROG_WRITE             :sprintf(RES_STR,"%s","PROG_WRITE"         );break;
      case PROG_READ              :sprintf(RES_STR,"%s","PROG_READ"          );break;
      case PROG_VERIFY            :sprintf(RES_STR,"%s","PROG_VERIFY"        );break;
      case PROG_PROTECT           :sprintf(RES_STR,"%s","PROG_PROTECT"       );break;
      case PROG_UNPROTECT         :sprintf(RES_STR,"%s","PROG_UNPROTECT"     );break;
      case PROG_BLANKCHECK        :sprintf(RES_STR,"%s","PROG_BLANKCHECK"    );break;
      case PROG_CTRL              :sprintf(RES_STR,"%s","PROG_CTRL"          );break;
      case PROG_EPROM             :sprintf(RES_STR,"%s","PROG_EPROM"         );break;
      case PROG_BOOTLOAD          :sprintf(RES_STR,"%s","PROG_BOOTLOAD"      );break;
      case PROG_ATE               :sprintf(RES_STR,"%s","PROG_ATE"           );break;
      case PROG_SVF               :sprintf(RES_STR,"%s","PROG_SVF"           );break;
      case PROG_IDCODE            :sprintf(RES_STR,"%s","PROG_IDCODE"        );break;
      case PROG_CHECK_OPT         :sprintf(RES_STR,"%s","PROG_CHECK_OPT"     );break;
      case PROG_PIO               :sprintf(RES_STR,"%s","PROG_PIO"           );break;
      case PROG_WRITE_OPT         :sprintf(RES_STR,"%s","PROG_WRITE_OPT"     );break;
      case PROG_READ_OPT          :sprintf(RES_STR,"%s","PROG_READ_OPT"      );break;
      case PROG_TEST              :sprintf(RES_STR,"%s","PROG_TEST"          );break;
      case PROG_USER_ID0          :sprintf(RES_STR,"%s","PROG_USER_ID0"      );break;
      case PROG_USER_ID1          :sprintf(RES_STR,"%s","PROG_USER_ID1"      );break;
      case PROG_USER_ID2          :sprintf(RES_STR,"%s","PROG_PROG_USER_ID2" );break;
      case PROG_EXECUTE           :sprintf(RES_STR,"%s","PROG_EXECUTE"       );break;
      case PROG_JMO_NO            :sprintf(RES_STR,"%s","PROG_JMO_NO"        );break;
      case PROG_DOWNLOAD          :sprintf(RES_STR,"%s","PROG_DOWNLOAD"      );break;
      case PROG_POWERON           :sprintf(RES_STR,"%s","PROG_POWERON"       );break;
      case PROG_POWEROFF          :sprintf(RES_STR,"%s","PROG_POWEROFF"      );break;
      case PROG_FINISH            :sprintf(RES_STR,"%s","PROG_FINISH"        );break;

      case ERROR_CONNECT          :sprintf(RES_STR,"%s","ERROR_CONNECT"      );break;
      case ERROR_PARAMETER        :sprintf(RES_STR,"%s","ERROR_PARAMETER"    );break;
      case ERR_FILE_NOT_FOUND     :sprintf(RES_STR,"%s","ERR_FILE_NOT_FOUND" );break;
      case ERROR_READ_FILE        :sprintf(RES_STR,"%s","ERROR_READ_FILE"    );break;
      case ERROR_WRITE_FILE       :sprintf(RES_STR,"%s","ERROR_WRITE_FILE"   );break;
      case ERROR_TOO_MANY_COMMAND :sprintf(RES_STR,"%s","ERROR_TOO_MANY_COMMAND");break;
      case ERROR_UNKNOWN_COMMAND  :sprintf(RES_STR,"%s","ERROR_UNKNOWN_COMMAND" );break;
      case ERROR_JMO_FILE         :sprintf(RES_STR,"%s","ERROR_JMO_FILE"     );break;
      case ERROR_JMO_DOWNLOAD     :sprintf(RES_STR,"%s","ERROR_JMO_DOWNLOAD" );break;
      case ERROR_UNKNOWN          :sprintf(RES_STR,"%s","ERROR_UNKNOW"       );break;

      case MODE_MONITOR           :sprintf(RES_STR,"%s","MODE_MONITOR"       );break;
      case MODE_PROGRAM           :sprintf(RES_STR,"%s","MODE_PROGRAM"       );break;

      default                     :sprintf(RES_STR,"%s","UNDEFINED ERROR"    );break;
    };
};

//̷ʽһ
//JM_RUN
//ɺ˳ձ״̬Ϣ
int programRUN(void)
{
  char c,i;
  u32 S;
  u32 resm;
  u32 S1,S2;
  char StatusString[11];
  char SS1[100],SS2[100],ss[100];

  for(i=0;i<40;i++){
    SS1[i]=' '; SS2[i]=' ';
  };
  SS1[40]='\0'; SS2[40]='\0';

  myOPENJMO(JMNO,FileNO);  //JMOļ


  do{
    printf("\n\n1/2/Aѡ̶˿,Q˳: ");
    //c =kbhit();
    //if(c)
    c =toupper(getch()); putch(c);
    printf("\n\n");

    switch (c){
      case '1':

          resm = myRUN(JMNO,1);
          if (resm == 0){
            printf("˿1̳ɹ");
          }else {
            RES2STR(resm);
            printf("˿1̳: %s",RES_STR);
          }
          break;
      case '2':

          resm = myRUN(JMNO,2);
          if (resm == 0){
            printf("˿2̳ɹ");
          }else {
            RES2STR(resm);
            printf("˿2̳: %s",RES_STR);
          }
          break;
      case 'A':

          myRUN(JMNO,0);
          break;
      case 'Q':
          myCLOSEJMO(JMNO);  //˳ǰȹرJMOļ
          return 0;
          //break;
      default :
        break;
    };
    c = 0;
  }while(1);

  //printf("\n");
  //return 0;

}

//̷ʽ
//JM_START
//JM_MESSAGEر̹е״̬Ϣ
int programSTART(void)
{
  char c,i,p,b;
  u32 S;
  u32 resm;
  char SS1[100],SS2[100],ss[200];
  unsigned int jj;

  for(i=0;i<60;i++){
    SS1[i]=' '; SS2[i]=' ';
  };
  SS1[60]='\0'; SS2[60]='\0';

  myOPENJMO(JMNO,FileNO);    //JMOļ

  printf("\n\n1/2/Aѡ̶˿,Q˳: ");
  printf("\n");

  do{

    c =kbhit();
    if(c) c =toupper(getch());

    switch (c){
      case '1':
          resm = mySTART(JMNO,1);
          break;
      case '2':
          resm = mySTART(JMNO,2);
          break;
      case 'A':
          mySTART(JMNO,0);
          break;
      case 'Q':
          myCLOSEJMO(JMNO); //˳ǰȹرJMOļ
          return 0;
          //break;
      default :
        break;
    };
    c = 0;
    
    resm = myMESSAGE(JMNO,0);

    p = (resm >> 24) & 0x3F; //˿

    b = (resm >> 16) & 0xFF; //

    S = resm & 0xff;         //״̬

    RES2STR(S);
    jj = 0;
    while(jj<StrLen(RES_STR)){
      ss[jj] = RES_STR[jj];
      jj++;
    };
    for(;jj<20;jj++) ss[jj] = ' ';            //ոñʾ
    ss[jj] = '\0';

    if (p == 1){ //P1 ̿
      //S1=S;
      sprintf(SS1,"P1: %s                              ", ss);
      for(i=0;i<(b/5);i++) SS1[i+23] ='.';
    }else
    if (p == 2){ //P2 ̿
      //S2 =S;
      sprintf(SS2,"P2: %s                              ", ss);
      for(i=0;i<(b/5);i++) SS2[i+23] ='.';
    }
    sprintf(ss,"%s%s",SS1,SS2);

    printf("%s\r",ss);

  //}while( (S1 != PROG_WAIT_KEY ) && (S2 != PROG_WAIT_KEY));
  }while(1);


  //printf("\n");
  //myCLOSEJMO(JMNO);
  //return 0;

}

//HEXתint
int htoi(char s[])
{
  int i;
  int n = 0;
  if (s[0] == '0' && (s[1] == 'x' || s[1] == 'X')){
    i = 2;
  }else{
    i = 0;
  }

  for (; (s[i] >= '0' && s[i] <= '9') || (s[i] >= 'a' && s[i] <= 'z') || (s[i] >= 'A' && s[i] <= 'Z'); ++i){
    if (tolower(s[i]) > '9'){
      n = 16 * n + (10 + tolower(s[i]) - 'a');
    }else{
      n = 16 * n + (tolower(s[i]) - '0');
    }
  }
  return n;
}

//ʾļϢ
int filedetail(char * ss)
{
  int i;
  u32 RES;
  unsigned n,jj;
  char S_DISK[255];//     := GetItem;
  char S_FILENAME[255];// := GetItem;
  char S_DESCRIBE[255];// := GetItem;
  char S_CHKSUM[255];//   := GetItem;
  char S_DATETIME[255];// := GetItem;
  char S_CHIPTYPE[255];// := GetItem;
  char S_SERIAL[255];//   := GetItem;
  char S_AES[255];//      := GetItem;
  char S_PID[255];//      := GetItem;
  char S_COUNTER[255];//  := GetItem;
  char S_START[255];//    := GetItem;
  char S_ATEM[255];//     := GetItem;
  char S_AUTOFILE[255];// := GetItem;
  //char s[255];
  char sp[255];
  char *pp;

   memset(S_DISK,0,255);
   memset(S_FILENAME,0,255);
   memset(S_DESCRIBE,0,255);
   memset(S_CHKSUM,0,255);
   memset(S_DATETIME,0,255);
   memset(S_CHIPTYPE,0,255);
   memset(S_SERIAL,0,255);
   memset(S_AES,0,255);
   memset(S_PID,0,255);
   memset(S_COUNTER,0,255);
   memset(S_START,0,255);
   memset(S_ATEM,0,255);
   memset(S_AUTOFILE,0,255);

   memset(sp,0,255);

  n = strlen(ss);
  for(jj=0;jj<n;jj++)
    sp[jj] = *ss++;
  pp = (char *)sp;

  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_DISK[jj++] =char( *pp++);
  };
  for(;jj<7;jj++) S_DISK[jj] = ' ';            //

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_FILENAME[jj++] = *pp++;
  };
  for(;jj<13;jj++) S_FILENAME[jj] = ' ';            //

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_DESCRIBE[jj++] = *pp++;
  };
  for(;jj<22;jj++) S_DESCRIBE[jj] = ' ';            //

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_CHKSUM[jj++] = *pp++;
  };
  for(;jj<12;jj++) S_CHKSUM[jj] = ' ';            //

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_DATETIME[jj++] = *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_CHIPTYPE[jj++] = *pp++;
  };
  i =  htoi(S_CHIPTYPE);
  ICType2Str(i);
  for(jj=0;jj<strlen(ICTypeStr);jj++)
    S_CHIPTYPE[jj] =ICTypeStr[jj];
  for(;jj<16;jj++) S_CHIPTYPE[jj] = ' ';            //
  S_CHIPTYPE[jj] = 0x0;

  *pp++;
  jj =0;
  while((jj<n)&&(*pp !=',')){
   S_SERIAL[jj++] = *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_AES[jj++]= *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_PID[jj++] = *pp++;
  };

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_COUNTER[jj++] = *pp++;
  };
  for(;jj<10;jj++) S_COUNTER[jj] = ' ';            //

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_START[jj++] = *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_ATEM[jj++] = *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_AUTOFILE[jj++] = *pp++;
  };

  printf("%s%s%s%s%s%s\n",S_DISK,S_FILENAME,S_DESCRIBE,S_CHKSUM,S_COUNTER,S_CHIPTYPE);

  return 0;
}

//ʾļĸϸϢ
int filedetail0(char * ss)
{
  int i;
  u32 RES;
  unsigned n, jj;
  char S_DISK[255];//     := GetItem;
  char S_FILENAME[255];// := GetItem;
  char S_DESCRIBE[255];// := GetItem;
  char S_CHKSUM[255];//   := GetItem;
  char S_DATETIME[255];// := GetItem;
  char S_CHIPTYPE[255];// := GetItem;
  char S_SERIAL[255];//   := GetItem;
  char S_AES[255];//      := GetItem;
  char S_PID[255];//      := GetItem;
  char S_COUNTER[255];//  := GetItem;
  char S_START[255];//    := GetItem;
  char S_ATEM[255];//     := GetItem;
  char S_AUTOFILE[255];// := GetItem;
  //char s[255];
  char sp[255];
  char *pp;

  memset(S_DISK,0,255);
  memset(S_FILENAME,0,255);
  memset(S_DESCRIBE,0,255);
  memset(S_CHKSUM,0,255);
  memset(S_DATETIME,0,255);
  memset(S_CHIPTYPE,0,255);
  memset(S_SERIAL,0,255);
  memset(S_AES,0,255);
  memset(S_PID,0,255);
  memset(S_COUNTER,0,255);
  memset(S_START,0,255);
  memset(S_ATEM,0,255);
  memset(S_AUTOFILE,0,255);

  memset(sp,0,255);

  n = strlen(ss);
  for(jj=0;jj<n;jj++)
    sp[jj] = *ss++;
  pp = (char *)sp;

  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_DISK[jj++] =char( *pp++);
  };
  for(;jj<6;jj++) S_DISK[jj] = ' ';            //ոʹʾ

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_FILENAME[jj++] = *pp++;
  };
  for(;jj<13;jj++) S_FILENAME[jj] = ' ';            //

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_DESCRIBE[jj++] = *pp++;
  };
  for(;jj<22;jj++) S_DESCRIBE[jj] = ' ';            //

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_CHKSUM[jj++] = *pp++;
  };
  for(;jj<12;jj++) S_CHKSUM[jj] = ' ';            //

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_DATETIME[jj++] = *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_CHIPTYPE[jj++] = *pp++;
  };
  i =  htoi(S_CHIPTYPE);
  ICType2Str(i);
  for(jj=0;jj<strlen(ICTypeStr);jj++)
    S_CHIPTYPE[jj] =ICTypeStr[jj];
  for(;jj<16;jj++) S_CHIPTYPE[jj] = ' ';            //
  S_CHIPTYPE[jj] = 0x0;

  *pp++;
  jj =0;
  while((jj<n)&&(*pp !=',')){
   S_SERIAL[jj++] = *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_AES[jj++]= *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_PID[jj++] = *pp++;
  };

  *pp++;
  jj = 0;
  while((jj<n) &&(*pp !=',')){
    S_COUNTER[jj++] = *pp++;
  };
  for(;jj<10;jj++) S_COUNTER[jj] = ' ';            //

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_START[jj++] = *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_ATEM[jj++] = *pp++;
  };

  *pp++;
  jj =0;
  while((jj<n) &&(*pp !=',')){
    S_AUTOFILE[jj++] = *pp++;
  };

  printf("\nļ  %s",S_FILENAME);
  //FN[20] = '\0';

  // ļڱڱλ FLASHTF
  printf("\n洢λã%s",S_DISK);

  // ļ
  printf("\nļ%s",S_DESCRIBE);

  //ļʱ
  printf("\nʱ䣺%s",S_DATETIME);

  //ļУ
  printf("\nУ  %s",S_CHKSUM);

  // оƬ
  //ICType2Str(JMVAR.ICTYPE);
  printf("\nоƬ%s",S_CHIPTYPE);

  // ǷAES
  printf("\nǷܣ%s",S_AES);

  // ̼
  printf("\n̼: %s",S_COUNTER);

  // ʽ
  printf("\n̷ʽ%s",S_START);

  // ǷԶļ
  printf("\n  : %s",S_AUTOFILE);

  printf("\n\n");
  printf("\nǷб̴   : %s",S_SERIAL);
  printf("\nǷ޶ : %s",S_PID);
  printf("\nATEƽ趨      : %s",S_ATEM);
  printf("\n\n");

  return 0;
}

void strcopy(char *d, char* s)
{ u8 i = 0;
  while ((*s != 0x0) && (i<250)){
    i++;
    *d++ = *s++;
  }
}

int main(int argc, char* argv[])
{
  char c,i;
  char name[255];
  int b,n;
  int res,*pp;
  char UseUSB = 1;
  HINSTANCE hDllInstu,hDllInstc;

  if ((argc == 2 ) && (UpperCase(*argv[1]) =='U'))
    UseUSB =1;
  if ((argc == 2 ) && (UpperCase(*argv[1]) =='C'))
    UseUSB =0;

  hDllInstu = LoadLibrary("JM_USB.dll");
  if(InitDLLu(hDllInstu)){
     printf("\nJM_USB.DLL ܼ!");
     printf("\n\n˳\n");
     c = getch();
     FreeLibrary(hDllInstu);
     FreeLibrary(hDllInstc);
     return(-1);    // DLL can not load
  }
  hDllInstc = LoadLibrary("JM_COM.dll");
  if(InitDLLc(hDllInstc)){
     printf("\nJM_COM.DLL ܼ!");
     printf("\n\n˳\n");
     c = getch();
     FreeLibrary(hDllInstu);
     FreeLibrary(hDllInstc);
     return(-1);    // DLL can not load
  }

  memset(name,0,250);

  if (UseUSB) {
    myRUN = myRUNu;
    myJM = myJMu;
    myMESSAGE = myMESSAGEu;
    mySNO = mySNOu;
    myNAME = myNAMEu;
    myFILE = myFILEu;
    myDELETE = myDELETEu;
    mySETAUTOFILE = mySETAUTOFILEu;
    myOPENJMO = myOPENJMOu;
    myCLOSEJMO = myCLOSEJMOu;
    mySTART = mySTARTu;
    myEXIT = myEXITu;
  }else{
    myRUN = myRUNc;
    myJM = myJMc;
    myMESSAGE = myMESSAGEc;
    mySNO = mySNOc;
    myNAME = myNAMEc;
    myFILE = myFILEc;
    myDELETE = myDELETEc;
    mySETAUTOFILE = mySETAUTOFILEc;
    myOPENJMO = myOPENJMOc;
    myCLOSEJMO = myCLOSEJMOc;
    mySTART = mySTARTc;
    myEXIT = myEXITc;
  };

  //رJMOļļ˳̬
  res = myCLOSEJMO(0);
  //˼̨ ѡһ̨в
  res = myJM(0);

  if (res == 0){
      printf("\n  ûӱ!");
      if(UseUSB){
        printf("\n  ǰUSBӷʽ\n  ˳мӲ'c'лCOMӷʽ\n");
      }else{
        printf("\n  ǰCOMӷʽ\n  ˳мӲ'u'лUSBӷʽ\n");
      };
      printf("\n\n˳\n");
      c = getch();
      myEXIT();
      FreeLibrary(hDllInstu);
      FreeLibrary(hDllInstc);
     return(-1);
  } else {
    printf("\n%3d̨\n",res);
    for( i=1;i<=res;i++){
      n = mySNO(i);
      sprintf(name, "%s",myNAME(i));
      printf( "%3d  SNO: %8x  NAME:'%s'",i,n,name);
    };
    if( res>1){
      //ӵı1̨Ҫѡ̨
      printf("\n\nѡ1..%d: ",res);

      c=getch();
      putch(c);
      n= int(c-'0');
      if ((n<1)||(n>res)){
        printf("\n! %c\n",c);

        printf("\n\n˳\n");
        c = getch();

        myEXIT();
        FreeLibrary(hDllInstu);
        FreeLibrary(hDllInstc);
        return(-1);
      };
      JMNO = n;    //ж̨ѡһ̨в
    }else{
      JMNO = 1;   //ֻһ̨
    }
  };
  printf("\n\n");

  // ѡıжٿɱļ
  while(1){
    pp = myFILE(JMNO,0);  //0жJMOļ
    c = char(*pp);
    res= int(c-'0');
    //n = int(pp[1]);
    if (res == 0){
        printf("\n %dűûļ!\n",JMNO);
        printf("\n\n˳\n");
        c = getch();
        FreeLibrary(hDllInstu);
        FreeLibrary(hDllInstc);
        myEXIT();
        return(-1);
    } else {
      printf("\n %dű%3dļ\n",JMNO,res);
      printf("\nļ  λ   ļ       ļ              У            оƬ\n");
      for( i=1;i<=res;i++){

        pp = myFILE(JMNO,i);   //i,ȡiļϢ

        strcopy(name, (char *)pp);

        printf("%4d    ",i);
        filedetail(name);
      };
      if( res>1){
        //ѡҪ̵ļ
        printf("\n\nѡļ1..%d: ",res);

        c=getch();
        putch(c);
        n= int(c-'0');
        if ((n<1)||(n>res)){
          printf("\n! %c\n",c);
          printf("\n\n˳\n");
          c = getch();

          myEXIT();
          FreeLibrary(hDllInstu);
          FreeLibrary(hDllInstc);
          return(-1);
        };
        FileNO = n;    //жļѡһļ
      }else{
        FileNO = 1;   //ֻһļ
      }
    };

    printf("\n%dű%dļ\n",JMNO,FileNO);
    //ʾѡļϸϢ
    pp = myFILE(JMNO,FileNO);
    strcopy(name, (char *)pp);
    filedetail0(name);

    printf("\n P:б  D:ɾļ  A:ʽ  B:ȡʽ  Q:˳");
    c =toupper(getch());   putch(c);
    switch (c){
      case 'P':
          //programRUN();                // ֱӱ(JM_RUN)
          programSTART();               // (JM_START)̲
          break;
      case 'D':
          printf("\nȷɾļ(Y/N)? " );
          c =toupper(getch()); putch(c);
          if (c == 'Y') myDELETE(JMNO,FileNO);
          break;
      case 'A':
          mySETAUTOFILE(JMNO,FileNO);
          break;
      case 'B':
          mySETAUTOFILE(JMNO,0);
          break;
      case 'Q':
          myEXIT();
          FreeLibrary(hDllInstu);
          FreeLibrary(hDllInstc);
          return 0;
          //break;
      default :
        break;
    } // case
  }   //while;

}






