unit DEMO_JM_U;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, CheckLst, ExtCtrls, Gauges, ComCtrls;

type
  u32 = longint;
  u8  = byte;
  pU8 = ^byte;

const
  JM     : u32 = 1;
  UseUSB : boolean = false;

const
//  DLLU_NAME = 'C:\JM3\JM3_PAS\JM3P\JM_USB.DLL';
//  DLLC_NAME = 'C:\JM3\JM3_PAS\JM3P\JM_COM.DLL';
  DLLU_NAME = 'JM_USB.DLL';
  DLLC_NAME = 'JM_COM.DLL';

function JMU_BAUDRATE(BAUDRATE: u32)                      : u32    ; cdecl; external DLLU_NAME name 'JM_BAUDRATE'   ;
function JMU_CLOSEJMO(JMNO: u32)                          : u32    ; cdecl; external DLLU_NAME name 'JM_CLOSEJMO'   ;
function JMU_COUNTER(JMNO: u32)                           : u32    ; cdecl; external DLLU_NAME name 'JM_COUNTER'    ;
function JMU_DELETE(JMNO: u32; N: u32)                    : u32    ; cdecl; external DLLU_NAME name 'JM_DELETE'     ;
function JMU_DOWNLOAD(JMNO: u32; F: u32; p: pointer)      : u32    ; cdecl; external DLLU_NAME name 'JM_DOWNLOAD'   ;
function JMU_EXIT                                         : u32    ; cdecl; external DLLU_NAME name 'JM_EXIT'       ;
function JMU_FID(JMNO: u32; F: u32; p: pointer)           : u32    ; cdecl; external DLLU_NAME name 'JM_FID'        ;
function JMU_FILE(JMNO: u32; F: u32)                      : pointer; cdecl; external DLLU_NAME name 'JM_FILE'       ;
function JMU_FORMAT(JMNO: u32)                            : u32    ; cdecl; external DLLU_NAME name 'JM_FORMAT'     ;
function JMU_JM(JMNO: u32)                                : u32    ; cdecl; external DLLU_NAME name 'JM_JM'         ;
function JMU_LASTERROR(JMNO: u32)                         : u32    ; cdecl; external DLLU_NAME name 'JM_LASTERROR'  ;
function JMU_LOGOFF                                       : u32    ; cdecl; external DLLU_NAME name 'JM_LOGOFF'     ;
function JMU_LOGON(M: u32; p: pointer)                    : u32    ; cdecl; external DLLU_NAME name 'JM_LOGON'      ;
function JMU_MESSAGE(JMNO: u32; P: u32)                   : u32    ; cdecl; external DLLU_NAME name 'JM_MESSAGE'    ;
function JMU_MODE(JMNO: u32)                              : u32    ; cdecl; external DLLU_NAME name 'JM_MODE'       ;
function JMU_NAME(JMNO: u32)                              : pointer; cdecl; external DLLU_NAME name 'JM_NAME'       ;
function JMU_OPENJMO(JMNO: u32; N: u32)                   : u32    ; cdecl; external DLLU_NAME name 'JM_OPENJMO'    ;
function JMU_POWER(JMNO: u32; P: u32; V: u32)             : u32    ; cdecl; external DLLU_NAME name 'JM_POWER'      ;
function JMU_READIO(JMNO: u32; P: u32; A: u32)            : u32    ; cdecl; external DLLU_NAME name 'JM_READIO'     ;
function JMU_RESET(JMNO: u32)                             : u32    ; cdecl; external DLLU_NAME name 'JM_RESET'      ;
function JMU_RUN(JMNO: u32; P: u32)                       : u32    ; cdecl; external DLLU_NAME name 'JM_RUN'        ;
function JMU_SERIAL(JMNO: u32; P: u32; L: u32; s: pointer): u32    ; cdecl; external DLLU_NAME name 'JM_SERIAL'     ;
function JMU_SETAUTOFILE(JMNO: u32; N: u32)               : u32    ; cdecl; external DLLU_NAME name 'JM_SETAUTOFILE';
function JMU_SETNAME(JMNO: u32; p: pointer)               : u32    ; cdecl; external DLLU_NAME name 'JM_SETNAME'    ;
function JMU_SETPASSWORD(JMNO: u32; p: pointer)           : u32    ; cdecl; external DLLU_NAME name 'JM_SETPASSWORD';
function JMU_SNO(JMNO: u32)                               : u32    ; cdecl; external DLLU_NAME name 'JM_SNO'        ;
function JMU_START(JMNO: u32; P: u32)                     : u32    ; cdecl; external DLLU_NAME name 'JM_START'      ;
function JMU_VERSION(JMNO: u32)                           : u32    ; cdecl; external DLLU_NAME name 'JM_VERSION'    ;
function JMU_WRITEIO(JMNO: u32; P: u32; A: u32; D: u32)   : u32    ; cdecl; external DLLU_NAME name 'JM_WRITEIO'    ;
function JMU_WRITELOG(p: pointer)                         : u32    ; cdecl; external DLLU_NAME name 'JM_WRITELOG'   ;

function JMC_BAUDRATE(BAUDRATE: u32)                      : u32    ; cdecl; external DLLC_NAME name 'JM_BAUDRATE'   ;
function JMC_CLOSEJMO(JMNO: u32)                          : u32    ; cdecl; external DLLC_NAME name 'JM_CLOSEJMO'   ;
function JMC_COUNTER(JMNO: u32)                           : u32    ; cdecl; external DLLC_NAME name 'JM_COUNTER'    ;
function JMC_DELETE(JMNO: u32; N: u32)                    : u32    ; cdecl; external DLLC_NAME name 'JM_DELETE'     ;
function JMC_DOWNLOAD(JMNO: u32; F: u32; p: pointer)      : u32    ; cdecl; external DLLC_NAME name 'JM_DOWNLOAD'   ;
function JMC_EXIT                                         : u32    ; cdecl; external DLLC_NAME name 'JM_EXIT'       ;
function JMC_FID(JMNO: u32; F: u32; p: pointer)           : u32    ; cdecl; external DLLC_NAME name 'JM_FID'        ;
function JMC_FILE(JMNO: u32; F: u32)                      : pointer; cdecl; external DLLC_NAME name 'JM_FILE'       ;
function JMC_FORMAT(JMNO: u32)                            : u32    ; cdecl; external DLLC_NAME name 'JM_FORMAT'     ;
function JMC_JM(JMNO: u32)                                : u32    ; cdecl; external DLLC_NAME name 'JM_JM'         ;
function JMC_LASTERROR(JMNO: u32)                         : u32    ; cdecl; external DLLC_NAME name 'JM_LASTERROR'  ;
function JMC_LOGOFF                                       : u32    ; cdecl; external DLLC_NAME name 'JM_LOGOFF'     ;
function JMC_LOGON(M: u32; p: pointer)                    : u32    ; cdecl; external DLLC_NAME name 'JM_LOGON'      ;
function JMC_MESSAGE(JMNO: u32; P: u32)                   : u32    ; cdecl; external DLLC_NAME name 'JM_MESSAGE'    ;
function JMC_MODE(JMNO: u32)                              : u32    ; cdecl; external DLLC_NAME name 'JM_MODE'       ;
function JMC_NAME(JMNO: u32)                              : pointer; cdecl; external DLLC_NAME name 'JM_NAME'       ;
function JMC_OPENJMO(JMNO: u32; N: u32)                   : u32    ; cdecl; external DLLC_NAME name 'JM_OPENJMO'    ;
function JMC_POWER(JMNO: u32; P: u32; V: u32)             : u32    ; cdecl; external DLLC_NAME name 'JM_POWER'      ;
function JMC_READIO(JMNO: u32; P: u32; A: u32)            : u32    ; cdecl; external DLLC_NAME name 'JM_READIO'     ;
function JMC_RESET(JMNO: u32)                             : u32    ; cdecl; external DLLC_NAME name 'JM_RESET'      ;
function JMC_RUN(JMNO: u32; P: u32)                       : u32    ; cdecl; external DLLC_NAME name 'JM_RUN'        ;
function JMC_SERIAL(JMNO: u32; P: u32; L: u32; s: pointer): u32    ; cdecl; external DLLC_NAME name 'JM_SERIAL'     ;
function JMC_SETAUTOFILE(JMNO: u32; N: u32)               : u32    ; cdecl; external DLLC_NAME name 'JM_SETAUTOFILE';
function JMC_SETNAME(JMNO: u32; p: pointer)               : u32    ; cdecl; external DLLC_NAME name 'JM_SETNAME'    ;
function JMC_SETPASSWORD(JMNO: u32; p: pointer)           : u32    ; cdecl; external DLLC_NAME name 'JM_SETPASSWORD';
function JMC_SNO(JMNO: u32)                               : u32    ; cdecl; external DLLC_NAME name 'JM_SNO'        ;
function JMC_START(JMNO: u32; P: u32)                     : u32    ; cdecl; external DLLC_NAME name 'JM_START'      ;
function JMC_VERSION(JMNO: u32)                           : u32    ; cdecl; external DLLC_NAME name 'JM_VERSION'    ;
function JMC_WRITEIO(JMNO: u32; P: u32; A: u32; D: u32)   : u32    ; cdecl; external DLLC_NAME name 'JM_WRITEIO'    ;
function JMC_WRITELOG(p: pointer)                         : u32    ; cdecl; external DLLC_NAME name 'JM_WRITELOG'   ;

type
  TJMFORM = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    sFile: TLabel;
    FileList: TCheckListBox;
    bDownloadFLASH: TBitBtn;
    bDownloadTF: TBitBtn;
    bDelete: TBitBtn;
    bPassword: TBitBtn;
    bSet: TBitBtn;
    bCancel: TBitBtn;
    LoadDialog: TOpenDialog;
    bProgram: TBitBtn;
    bConnect: TBitBtn;
    bPA: TBitBtn;
    bP2: TBitBtn;
    bP1: TBitBtn;
    pStop: TBitBtn;
    tStatus: TTimer;
    cSTART2: TCheckBox;
    cBUSY2: TCheckBox;
    cOK2: TCheckBox;
    cNG2: TCheckBox;
    cSTART1: TCheckBox;
    cBUSY1: TCheckBox;
    cOK1: TCheckBox;
    cNG1: TCheckBox;
    ProgressBar1: TProgressBar;
    ProgressBar2: TProgressBar;
    lP1: TLabel;
    lP2: TLabel;
    lCounter: TLabel;
    cP1: TCheckBox;
    cP2: TCheckBox;
    eSerial: TEdit;
    bSerial: TButton;
    cPORT: TComboBox;
    cJM: TComboBox;
    procedure bConnectClick(Sender: TObject);
    procedure FileListClickCheck(Sender: TObject);
    procedure bProgramClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bP1Click(Sender: TObject);
    procedure bP2Click(Sender: TObject);
    procedure bPAClick(Sender: TObject);
    procedure pStopClick(Sender: TObject);
    procedure tStatusTimer(Sender: TObject);
    procedure bDeleteClick(Sender: TObject);
    procedure bCancelClick(Sender: TObject);
    procedure bSetClick(Sender: TObject);
    procedure bDownloadFLASHClick(Sender: TObject);
    procedure bDownloadTFClick(Sender: TObject);
    procedure bPasswordClick(Sender: TObject);
    procedure bSerialClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  JMFORM: TJMFORM;

implementation

{$R *.DFM}

uses JM_DEF, pDES;

const
  ValHex   : array [0..$FF] of array[1..2] of char = (
    '00','01','02','03','04','05','06','07','08','09','0A','0B','0C','0D','0E','0F',
    '10','11','12','13','14','15','16','17','18','19','1A','1B','1C','1D','1E','1F',
    '20','21','22','23','24','25','26','27','28','29','2A','2B','2C','2D','2E','2F',
    '30','31','32','33','34','35','36','37','38','39','3A','3B','3C','3D','3E','3F',
    '40','41','42','43','44','45','46','47','48','49','4A','4B','4C','4D','4E','4F',
    '50','51','52','53','54','55','56','57','58','59','5A','5B','5C','5D','5E','5F',
    '60','61','62','63','64','65','66','67','68','69','6A','6B','6C','6D','6E','6F',
    '70','71','72','73','74','75','76','77','78','79','7A','7B','7C','7D','7E','7F',
    '80','81','82','83','84','85','86','87','88','89','8A','8B','8C','8D','8E','8F',
    '90','91','92','93','94','95','96','97','98','99','9A','9B','9C','9D','9E','9F',
    'A0','A1','A2','A3','A4','A5','A6','A7','A8','A9','AA','AB','AC','AD','AE','AF',
    'B0','B1','B2','B3','B4','B5','B6','B7','B8','B9','BA','BB','BC','BD','BE','BF',
    'C0','C1','C2','C3','C4','C5','C6','C7','C8','C9','CA','CB','CC','CD','CE','CF',
    'D0','D1','D2','D3','D4','D5','D6','D7','D8','D9','DA','DB','DC','DD','DE','DF',
    'E0','E1','E2','E3','E4','E5','E6','E7','E8','E9','EA','EB','EC','ED','EE','EF',
    'F0','F1','F2','F3','F4','F5','F6','F7','F8','F9','FA','FB','FC','FD','FE','FF'
  );

type
  tpC = ^char;

var
  RES   : U32;
  JMMODE: U32;
  hAUTOF: boolean;

function JM_BAUDRATE(BAUDRATE: u32): u32;
begin
  if UseUSB then JM_BAUDRATE := JMU_BAUDRATE(BAUDRATE) else JM_BAUDRATE := JMC_BAUDRATE(BAUDRATE);
end;

function JM_CLOSEJMO(JMNO: u32): u32;
begin
  if UseUSB then JM_CLOSEJMO := JMU_CLOSEJMO(JMNO) else JM_CLOSEJMO := JMC_CLOSEJMO(JMNO);
end;

function JM_COUNTER(JMNO: u32): u32;
begin
  if UseUSB then JM_COUNTER := JMU_COUNTER(JMNO) else JM_COUNTER := JMC_COUNTER(JMNO);
end;

function JM_DELETE(JMNO: u32; N: u32): u32;
begin
  if UseUSB then JM_DELETE := JMU_DELETE(JMNO, N) else JM_DELETE := JMC_DELETE(JMNO, N);
end;

function JM_DOWNLOAD(JMNO: u32; F: u32; p: pointer): u32;
begin
  if UseUSB then JM_DOWNLOAD := JMU_DOWNLOAD(JMNO, F, p) else JM_DOWNLOAD := JMC_DOWNLOAD(JMNO, F, p);
end;

function JM_EXIT: u32;
begin
  if UseUSB then JM_EXIT := JMU_EXIT else JM_EXIT := JMC_EXIT;
end;

function JM_FID(JMNO: u32; F: u32; p: pointer): u32;
begin
  if UseUSB then JM_FID := JMU_FID(JMNO, F, p) else JM_FID := JMC_FID(JMNO, F, p);
end;

function JM_FILE(JMNO: u32; F: u32): pointer;
begin
  if UseUSB then JM_FILE := JMU_FILE(JMNO, F) else JM_FILE := JMC_FILE(JMNO, F);
end;

function JM_FORMAT(JMNO: u32): u32;
begin
  if UseUSB then JM_FORMAT := JMU_FORMAT(JMNO) else JM_FORMAT := JMC_FORMAT(JMNO);
end;

function JM_JM(JMNO: u32): u32;
begin
  if UseUSB then JM_JM := JMU_JM(JMNO) else JM_JM := JMC_JM(JMNO);
end;

function JM_LASTERROR(JMNO: u32): u32;
begin
  if UseUSB then JM_LASTERROR := JMU_LASTERROR(JMNO) else JM_LASTERROR := JMC_LASTERROR(JMNO);
end;

function JM_LOGOFF: u32;
begin
  if UseUSB then JM_LOGOFF := JMU_LOGOFF else JM_LOGOFF := JMC_LOGOFF;
end;

function JM_LOGON(M: u32; p: pointer): u32;
begin
  if UseUSB then JM_LOGON := JMU_LOGON(M, p) else JM_LOGON := JMC_LOGON(M, p);
end;

function JM_MESSAGE(JMNO: u32; P: u32): u32;
begin
  if UseUSB then JM_MESSAGE := JMU_MESSAGE(JMNO, P) else JM_MESSAGE := JMC_MESSAGE(JMNO, P);
end;

function JM_MODE(JMNO: u32): u32;
begin
  if UseUSB then JM_MODE := JMU_MODE(JMNO) else JM_MODE := JMC_MODE(JMNO);
end;

function JM_NAME(JMNO: u32): pointer;
begin
  if UseUSB then JM_NAME := JMU_NAME(JMNO) else JM_NAME := JMC_NAME(JMNO);
end;

function JM_OPENJMO(JMNO: u32; N: u32): u32;
begin
  if UseUSB then JM_OPENJMO := JMU_OPENJMO(JMNO, N) else JM_OPENJMO := JMC_OPENJMO(JMNO, N);
end;

function JM_POWER(JMNO: u32; P: u32; V: u32): u32;
begin
  if UseUSB then JM_POWER := JMU_POWER(JMNO, P, V) else JM_POWER := JMC_POWER(JMNO, P, V);
end;

function JM_READIO(JMNO: u32; P: u32; A: u32): u32;
begin
  if UseUSB then JM_READIO := JMU_READIO(JMNO, P, A) else JM_READIO := JMC_READIO(JMNO, P, A);
end;

function JM_RESET(JMNO: u32): u32;
begin
  if UseUSB then JM_RESET := JMU_RESET(JMNO) else JM_RESET := JMC_RESET(JMNO);
end;

function JM_RUN(JMNO: u32; P: u32): u32;
begin
  if UseUSB then JM_RUN := JMU_RUN(JMNO, P) else JM_RUN := JMC_RUN(JMNO, P);
end;

function JM_SERIAL(JMNO: u32; P: u32; L: u32; s: pointer): u32;
begin
  if UseUSB then JM_SERIAL := JMU_SERIAL(JMNO, P, L, s) else JM_SERIAL := JMC_SERIAL(JMNO, P, L, s);
end;

function JM_SETAUTOFILE(JMNO: u32; N: u32): u32;
begin
  if UseUSB then JM_SETAUTOFILE := JMU_SETAUTOFILE(JMNO, N) else JM_SETAUTOFILE := JMC_SETAUTOFILE(JMNO, N);
end;

function JM_SETNAME(JMNO: u32; p: pointer): u32;
begin
  if UseUSB then JM_SETNAME := JMU_SETNAME(JMNO, p) else JM_SETNAME := JMC_SETNAME(JMNO, p);
end;

function JM_SETPASSWORD(JMNO: u32; p: pointer): u32;
begin
  if UseUSB then JM_SETPASSWORD := JMU_SETPASSWORD(JMNO, p) else JM_SETPASSWORD := JMC_SETPASSWORD(JMNO, p);
end;

function JM_SNO(JMNO: u32): u32;
begin
  if UseUSB then JM_SNO := JMU_SNO(JMNO) else JM_SNO := JMC_SNO(JMNO);
end;

function JM_START(JMNO: u32; P: u32): u32;
begin
  if UseUSB then JM_START := JMU_START(JMNO, P) else JM_START := JMC_START(JMNO, P);
end;

function JM_VERSION(JMNO: u32): u32;
begin
  if UseUSB then JM_VERSION := JMU_VERSION(JMNO) else JM_VERSION := JMC_VERSION(JMNO);
end;

function JM_WRITEIO(JMNO: u32; P: u32; A: u32; D: u32): u32;
begin
  if UseUSB then JM_WRITEIO := JMU_WRITEIO(JMNO, P, A, D) else JM_WRITEIO := JMC_WRITEIO(JMNO, P, A, D);
end;

function JM_WRITELOG(p: pointer): u32;
begin
  if UseUSB then JM_WRITELOG := JMU_WRITELOG(p) else JM_WRITELOG := JMC_WRITELOG(p);
end;

function GenString(p: pointer): shortstring;
var
   pC: tpC;
   S : shortstring;
begin
  pC := tpC(p);
  S  := '';

  while pC^ <> #0 do begin
    S := S + pC^;
    inc(pC);
  end;
  GenString := S;
end;

function IDName: shortstring;
var p: pointer;
begin
  p := JM_NAME(JM);
  IDName := GenString(p);
end;

function S2(B: byte): shortstring;
begin
  S2 := ValHex[B];
end;

function S4(W: word): shortstring;
begin
  S4 := S2((W shr 8) and $FF) + S2(W and $FF);
end;

function S8(D: dword): shortstring;
begin
  S8 := S4((D shr 16) and $FFFF) + S4(D and $FFFF);
end;

function ICTypeStr(ICType: u32): shortstring;
begin
  case ICType of
    IC_24            : Result := '24xx';
    IC_25            : Result := '25xx';
    IC_XMC1000       : Result := 'XMC1000-UART';
    IC_XC2000        : Result := 'XC2000-UART';
    IC_XMC4000       : Result := 'XMC4000-UART';
    IC_XMC4000S      : Result := 'XMC4000-SWD';
    IC_XMC4000W      : Result := 'XMC4000-WISP';
    IC_XMC1xSx       : Result := 'XMC1xSx-UART';
    IC_XC800         : Result := 'XC800-UART';
    IC_XC800W        : Result := 'XC800-WISP';
    IC_TLE984X       : Result := 'TLE984X-LIN';
    IC_TLE985X       : Result := 'TLE985X-LIN';
    IC_TLE986X7X     : Result := 'TLE986X7X-LIN';
    IC_TLE98XX       : Result := 'TLE98XX-SWD';
    IC_CORTEX_M      : Result := 'CORTEX-M';
    IC_STM32         : Result := 'STM32-SWD';
    IC_STM32I        : Result := 'STM32-ISP';
    IC_STM32W        : Result := 'STM32-WISP';
    IC_ICSP8         : Result := 'PIC8-ICSP';
    IC_NXPLPCM       : Result := 'NXPLPCM-SWD';
    IC_NXPLPCMI      : Result := 'NXPLPCM-ISP';
    IC_NXPLPCMW      : Result := 'NXPLPCM-WISP';
    IC_NUVOTON       : Result := 'NUVOTON-SWD';
    IC_NUVOTONI      : Result := 'NUVOTON-ISP';
    IC_NUVOTONW      : Result := 'NUVOTON-WISP';
    IC_GD32          : Result := 'GigaDevice';
    IC_GD32I         : Result := 'GigaDevice-ISP';
    IC_GD32W         : Result := 'GigaDevice-WISP';
    IC_LKS32         : Result := 'LKS32';
    IC_LKS32I        : Result := 'LKS32-ISP';
    IC_LKS32W        : Result := 'LKS32-WISP';
    IC_MM32          : Result := 'MindMotion';
    IC_MM32I         : Result := 'MindMotion-ISP';
    IC_MM32W         : Result := 'MindMotion-WISP';
    IC_AT89LP        : Result := 'AT89LP-SPI';
    IC_AT89LPI       : Result := 'AT89LP-ISP';
    IC_AT89LPW       : Result := 'AT89LP-WISP';
    IC_ME            : Result := 'ME9101';
    IC_JTAG_SVF      : Result := 'JTAG_SVF';
    IC_TMS320F       : Result := 'TMS320F-UART';
    IC_TMS320FI      : Result := 'TMS320F-ISP';
    IC_TMS320FW      : Result := 'TMS320F-WISP';
    IC_RENESAS_RX200 : Result := 'RENESAS-FINE';
    IC_RENESAS_RX200I: Result := 'RENESAS-SCI';
    IC_RENESAS_RX200W: Result := 'RENESAS_WSCI';

                  else Result := 'UNKNOW';
  end;
end;

function StatusString(S: u32): shortstring;
begin
  StatusString := '';

  case S of
    OK                    : StatusString := 'OK'                    ;
    ERROR_MONI            : StatusString := 'ERROR_MONI'            ;
    ERROR_ALGO            : StatusString := 'ERROR_ALGO'            ;
    ERROR_RTC             : StatusString := 'ERROR_RTC'             ;
    ERROR_FLASH_FORMAT    : StatusString := 'ERROR_FLASH_FORMAT'    ;
    ERROR_FLASH_TF        : StatusString := 'ERROR_FLASH_TF'        ;
    ERROR_FPGA_ID         : StatusString := 'ERROR_FPGA_ID'         ;
    ERROR_FPGA_CFG        : StatusString := 'ERROR_FPGA_CFG'        ;
    ERROR_FPGA_IP         : StatusString := 'ERROR_FPGA_IP'         ;
    ERROR_FLASH_ID        : StatusString := 'ERROR_FLASH_ID'        ;
    ERROR_FLASH_CFG       : StatusString := 'ERROR_FLASH_CFG'       ;

    ERROR_CHIPTYPE        : StatusString := 'ERROR_CHIPTYPE'        ;
    ERROR_PROGID          : StatusString := 'ERROR_PROGID'          ;
    ERROR_COUNTER         : StatusString := 'ERROR_COUNTER'         ;
    ERROR_AES             : StatusString := 'ERROR_AES'             ;
    ERROR_CHKSUM          : StatusString := 'ERROR_CHKSUM'          ;

    PROG_NULL             : StatusString := 'PROG_NULL'             ;
    PROG_WAIT_KEY         : StatusString := 'PROG_WAIT_KEY'         ;
    PROG_AUTO             : StatusString := 'PROG_AUTO'             ;
    PROG_CONNECT          : StatusString := 'PROG_CONNECT'          ;
    PROG_RESTORE          : StatusString := 'PROG_RESTORE'          ;
    PROG_ERASE            : StatusString := 'PROG_ERASE'            ;
    PROG_WRITE            : StatusString := 'PROG_WRITE'            ;
    PROG_READ             : StatusString := 'PROG_READ'             ;
    PROG_VERIFY           : StatusString := 'PROG_VERIFY'           ;
    PROG_PROTECT          : StatusString := 'PROG_PROTEXT'          ;
    PROG_UNPROTECT        : StatusString := 'PROG_UNPROTECT'        ;
    PROG_BLANKCHECK       : StatusString := 'PROG_BLANKCHECK'       ;
    PROG_CTRL             : StatusString := 'PROG_CTRL'             ;
    PROG_EPROM            : StatusString := 'PROG_EPROM'            ;
    PROG_BOOTLOAD         : StatusString := 'PROG_BOOTLOAD'         ;
    PROG_ATE              : StatusString := 'PROG_ATE'              ;

    // SVF
    PROG_SVF              : StatusString := 'PROG_SVF'              ;
    PROG_IDCODE           : StatusString := 'PROG_IDCODE'           ;
    PROG_CHECK_OPT        : StatusString := 'PROG_CHECK_OPT'        ;
    PROG_PIO              : StatusString := 'PROG_PIO'              ;
    PROG_WRITE_OPT        : StatusString := 'PROG_WRITE_OPT'        ;
    PROG_READ_OPT         : StatusString := 'PROG_READ_OPT'         ;
    PROG_TEST             : StatusString := 'PROG_TEST'             ;

    PROG_USER_ID0         : StatusString := 'PROG_USER_ID0'         ;
    PROG_USER_ID1         : StatusString := 'PROG_USER_ID1'         ;
    PROG_USER_ID2         : StatusString := 'PROG_USER_ID2'         ;

    PROG_EXECUTE          : StatusString := 'PROG_EXECUTE'          ;
    PROG_JMO_NO           : StatusString := 'PROG_JMO_NO'           ;
    PROG_DOWNLOAD         : StatusString := 'PROG_DOWNLOAD'         ;
    PROG_POWERON          : StatusString := 'PROG_POWERON'          ;
    PROG_POWEROFF         : StatusString := 'PROG_POWEROFF'         ;
    PROG_FINISH           : StatusString := 'PROG_FINISH'           ;

    ERROR_CONNECT         : StatusString := 'ERROR_CONNECT'         ;
    ERROR_PARAMETER       : StatusString := 'ERROR_PARAMETER'       ;
    ERROR_FILE_NOT_FOUND  : StatusString := 'ERROR_FILE_NOT_FOUND'  ;
    ERROR_READ_FILE       : StatusString := 'ERROR_READ_FILE'       ;
    ERROR_WRITE_FILE      : StatusString := 'ERROR_WRITE_FILE'      ;
    ERROR_TOO_MANY_COMMAND: StatusString := 'ERROR_TOO_MANY_COMMAND';
    ERROR_UNKNOWN_COMMAND : StatusString := 'ERROR_UNKNOWN_COMMAND' ;
    ERROR_JMO_FILE        : StatusString := 'ERROR_JMO_FILE'        ;
    ERROR_JMO_DOWNLOAD    : StatusString := 'ERROR_JMO_DOWNLOAD'    ;
    ERROR_UNKNOWN         : StatusString := 'ERROR_UNKNOWN'         ;
    MODE_MONITOR          : StatusString := 'MODE_MONITOR'          ;
    MODE_PROGRAM          : StatusString := 'MODE_PROGRAM'          ;
    else                    StatusString := 'UNKNOWN ERROR'         ;
  end;
end;

procedure UpdateForm;
var
  i    : u32;
  c    : boolean;
  n    : u32;
  SNAME: shortstring;
  SNO  : u32;
begin
  RES := JM_MODE(JM);
  with JMFORM do begin
    if RES = ERROR_CONNECT then begin
      Caption := 'JM3 NOT CONNECT';
      JMMODE  := MODE_MONITOR;
      if JMMODE = MODE_MONITOR then begin
        Panel1.Visible := true ;
        Panel2.Visible := false;
      end else begin
        Panel1.Visible := false;
        Panel2.Visible := true ;
      end;
      FileList.Items.Clear;
      bDownloadFLASH.Enabled := false;
      bDownloadTF.Enabled    := false;
      bDelete.Enabled        := false;
      bProgram.Enabled       := false;
      bPassword.Enabled      := false;
      bSet.Enabled           := false;
      bCancel.Enabled        := false;
    end else begin
      JMMODE := RES;
      if JMMODE = MODE_MONITOR then begin
        Panel1.Visible := true ;
        Panel2.Visible := false;
      end else begin
        Panel1.Visible := false;
        Panel2.Visible := true ;
      end;

      SNO   := JM_SNO(JM);
      SNAME := GenString(JM_NAME(JM));
      Caption := 'JM3 CONNECT: ' + S8(SNO) + '  ' + SNAME;
      bPassword.Enabled := true;
      bP1.Enabled       := true;
      bP2.Enabled       := true;
      bPA.Enabled       := true;
      pStop.Enabled     := true;
      if FileList.Items.Count = 0 then begin
        bDelete.Enabled        := false;
        bDownloadFLASH.Enabled := true ;
        bDownloadTF.Enabled    := true ;
        bSet.Enabled           := false;
      end else begin
        bDelete.Enabled        := false;
        bDownloadFLASH.Enabled := true ;
        bDownloadTF.Enabled    := true ;
        c := false;
        for i := 1 to FileList.Items.Count do begin
          if FileList.State[i-1] = cbChecked then c := true;
        end;

        if c then begin
          bDelete.Enabled := true ;
        end;

        // only select 1 may set Auto File
        n := 0;
        for i := 1 to FileList.Items.Count do begin
          if FileList.State[i-1] = cbChecked then begin
            inc(n);
          end;
        end;

        bSet.Enabled     := (n=1);
        bProgram.Enabled := (n=1);

        bCancel.Enabled := hAUTOF;
      end;
    end;
  end;
end;

procedure UpdateFileList;
var
  i : u32;
  j : u32;
  N : u32;
  s : shortstring;
  pC: tPC;

  S_DISK     : shortstring;
  S_FILENAME : shortstring;
  S_DESCRIBE : shortstring;
  S_CHKSUM   : shortstring;
  S_DATETIME : shortstring;
  S_CHIPTYPE : shortstring;
  S_SERIAL   : shortstring;
  S_AES      : shortstring;
  S_PID      : shortstring;
  S_COUNTER  : shortstring;
  S_START    : shortstring;
  S_ATEM     : shortstring;
  S_AUTOFILE : shortstring;

  RS: shortstring;
  SI: u32;

  function Space(S: shortstring; N: integer): shortstring;
  begin
    S := S + '                   ';
    S[0] := char(N);
    Space := S;
  end;

  function ToVal(S: shortstring): u32;
  var
    D: u32;
    I: u32;
    B: u8 ;
  begin
    S := UpperCase(S);
    D := 0;
    for I := 3 to 10 do begin
      if S[I] in ['0'..'9'] then
        B := byte(S[I]) - byte('0')
      else B := byte(S[I]) - byte('A') + 10;
      D := (D shl 4) + B;
    end;
    ToVal := D;
  end;

  function GetItem: shortstring;
  var
    S: shortstring;
  begin
    S := '';
    while (SI <= length(RS)) and (RS[SI] <> ',') do begin
      S := S + RS[SI];
      inc(SI);
    end;
    // skip ','
    if (SI <= length(RS)) and (RS[SI] = ',') then inc(SI);
    GetItem := S;
  end;

begin
  hAUTOF := false;

  with JMFORM do begin
    FileList.Items.Clear;
    pC := JM_FILE(JM, 0);
    RS  := GenString(pC);
    if RS <> '' then Val(RS, N, j) else N := 0;
    for i := 1 to N do begin
      pC := JM_FILE(JM, i);
      RS := GenString(pC);
      if RS <> '' then begin
        SI := 1;

        S_DISK     := GetItem;
        S_FILENAME := GetItem;
        S_DESCRIBE := GetItem;
        S_CHKSUM   := GetItem;
        S_DATETIME := GetItem;
        S_CHIPTYPE := GetItem;
        S_SERIAL   := GetItem;
        S_AES      := GetItem;
        S_PID      := GetItem;
        S_COUNTER  := GetItem;
        S_START    := GetItem;
        S_ATEM     := GetItem;
        S_AUTOFILE := GetItem;

        // FileName                  DISK               DESCRIBE                CHECKSUM                     CHIPTYPE
        s := Space(S_FILENAME, 14) + Space(S_DISK, 8) + Space(S_DESCRIBE, 22) + S8(ToVal(S_CHKSUM)) + '  ' + Space(ICTypeStr(ToVal(S_CHIPTYPE)), 16);

        //       ATE                COUNTER                START                AUTOFILE
        s := s + Space(S_AES, 10) + Space(S_COUNTER, 14) + Space(S_START, 14) + Space(S_AUTOFILE, 3);

        if S_AUTOFILE = 'Y' then hAUTOF := true;
      end else s := '';
      FileList.Items.Add(s);
    end;
  end;
end;

procedure CheckError;
begin
  if (RES <> OK) then UpdateForm;
end;

procedure TJMFORM.bConnectClick(Sender: TObject);
var E: integer;
begin
  if cPORT.Text = 'USB' then UseUSB := true else UseUSB := false;
  Val(cJM.Text, JM, E); if JM = 0 then JM := 1;

  RES := JM_MODE(JM);
  UpdateFileList;
  UpdateForm;
end;

procedure TJMFORM.FileListClickCheck(Sender: TObject);
begin
  UpdateForm;
end;

procedure TJMFORM.bProgramClick(Sender: TObject);
var
  i: u32;
  p: u8 ;
begin
  p := 0;
  with JMFORM do begin
    for i := 1 to FileList.Items.Count do begin
      if FileList.State[i-1] = cbChecked then p := i;
    end;
  end;
  if p <> 0 then begin
//    RES := JM_FILE(p);
    RES := JM_OPENJMO(JM, p);
    if RES <> OK then begin
      MessageDlg(StatusString(RES), mtInformation, [mbOK], 0);
    end;
    UpdateForm;
  end;
  CheckError;
end;

procedure TJMFORM.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  RES := JM_EXIT;
end;

procedure TJMFORM.bP1Click(Sender: TObject);
begin
  RES := JM_START(JM, 1);
  CheckError;
end;

procedure TJMFORM.bP2Click(Sender: TObject);
begin
  RES := JM_START(JM, 2);
  CheckError;
end;

procedure TJMFORM.bPAClick(Sender: TObject);
begin
  RES := JM_START(JM, 0);
  CheckError;
end;

procedure TJMFORM.pStopClick(Sender: TObject);
begin
  RES := JM_CLOSEJMO(JM);
  UpdateForm;
  CheckError;
end;

procedure TJMFORM.tStatusTimer(Sender: TObject);
var
  s     : shortstring;
  M     : u32;
  PNO   : u8;
  BAR   : u8;
  ATE   : u8;
  STATUS: u8;
begin
  if JMMODE <> MODE_MONITOR then with JMFORM do begin
    M      := JM_MESSAGE(JM, 0);
    PNO    := (M shr 24) and $FF;
    BAR    := (M shr 16) and $FF;
    ATE    := (M shr  8) and $FF;
    STATUS := (M       ) and $FF;
    if PNO = $01 then begin
      lP1.Caption := StatusString(STATUS);
      ProgressBar1.Position := BAR;
      cBUSY1.Checked  := (ATE and $01) <> 0;
      cOK1.Checked    := (ATE and $02) <> 0;
      cNG1.Checked    := (ATE and $04) <> 0;
      cSTART1.Checked := (ATE and $08) <> 0;
    end else begin
      lP2.Caption := StatusString(STATUS);
      ProgressBar2.Position := BAR;
      cBUSY2.Checked  := (ATE and $01) <> 0;
      cOK2.Checked    := (ATE and $02) <> 0;
      cNG2.Checked    := (ATE and $04) <> 0;
      cSTART2.Checked := (ATE and $08) <> 0;
    end;

    // Counter
    RES := JM_COUNTER(JM);
    str(RES:1, s);
    if RES = 0 then lCounter.Caption := '' else lCounter.Caption := 'Counter: ' + s;
  end;
end;

procedure TJMFORM.bDeleteClick(Sender: TObject);
var
  i: integer;
begin
  if JMFORM.FileList.Items.Count = 0 then exit;

  for i := 1 to JMFORM.FileList.Items.Count do begin
    if JMFORM.FileList.State[i-1] = cbChecked then begin
      RES := JM_DELETE(JM, i);
    end;
  end;

  UpdateFileList;
  UpdateForm;
  CheckError;
end;

procedure TJMFORM.bSetClick(Sender: TObject);
var
  i: u32;
  p: u8 ;
begin
  p := 0;
  with JMFORM do begin
    for i := 1 to FileList.Items.Count do begin
      if FileList.State[i-1] = cbChecked then p := i;
    end;
  end;
  if p <> 0 then begin
    RES := JM_SETAUTOFILE(JM, p);
  end;

  UpdateFileList;
  UpdateForm;
  CheckError;
end;

procedure TJMFORM.bCancelClick(Sender: TObject);
begin
  RES := JM_SETAUTOFILE(JM, 255);

  UpdateFileList;
  UpdateForm;
  CheckError;
end;

procedure TJMFORM.bDownloadFLASHClick(Sender: TObject);
var
  DFN: shortstring;
begin
  with LoadDialog do begin
    DefaultExt := '';
    Filter     := '*.JMO|*.JMO|*.*|*.*';
    Title      := 'Download File';
    if Execute then begin
      DFN := FileName;
      if Pos('.', DFN) = 0 then DFN := DFN + '.JMO';
      DFN := DFN + #0;
      RES := JM_DOWNLOAD(JM, FLASH, @DFN[1]);
    end;
  end;

  UpdateFileList;
  UpdateForm;
  CheckError;
end;

procedure TJMFORM.bDownloadTFClick(Sender: TObject);
var
  DFN: shortstring;
begin
  with LoadDialog do begin
    DefaultExt := '';
    Filter     := '*.JMO|*.JMO|*.*|*.*';
    Title      := 'Download File';
    if Execute then begin
      DFN := FileName;
      if Pos('.', DFN) = 0 then DFN := DFN + '.JMO';
      DFN := DFN + #0;
      RES := JM_DOWNLOAD(JM, TF, @DFN[1]);
    end;
  end;

  UpdateFileList;
  UpdateForm;
  CheckError;
end;

procedure TJMFORM.bPasswordClick(Sender: TObject);
var s: shortstring;
begin
  with fDES do begin
    eDES.Text  := '';
    eDESr.Text := '';
    eName.Text := IDName;
    if ShowModal = mrOK then begin
      if eDES.Text <> eDESr.Text then begin
        MessageDlg('Password Error', mtInformation, [mbOK], 0);
      end else begin
        s   := eDES.Text + #0;
        RES := JM_SETPASSWORD(JM, @s[1]);

        s := eName.Text;
        while (length(s) <> 0) and ( (s[length(s)] = ' ') or (s[length(s)] = #9) ) do dec(s[0]);
        s   := s + #0;
        RES := JM_SETNAME(JM, @s[1]);
        UpdateForm;
      end;
    end;
  end;
end;

procedure TJMFORM.bSerialClick(Sender: TObject);
var
  C: u8;
  L: u8;
  S: shortstring;
begin
  C := 0;
  if cP1.Checked then C := C or $01;
  if cP2.Checked then C := C or $02;

  S := eSerial.Text;
  L := length(S);
  JM_SERIAL(JM, C, L, @S[1]);
end;

var LOGFS: shortstring;

begin
  JMMODE := MODE_MONITOR ;
  RES    := ERROR_CONNECT;
  LOGFS  := 'DEMO_JM.LOG'+#0;
  RES    := JM_LOGON(CREATE, pointer(@LOGFS[1]));
end.
