unit JM_DEF;

interface

const
  FLASH  = 0;
  TF     = 1;

  CREATE = 0;
  APPEND = 1;

  OK                     =  0;
  ERROR_MONI             =  1;
  ERROR_ALGO             =  2;
  ERROR_RTC              =  3;
  ERROR_FLASH_FORMAT     =  4;
  ERROR_FLASH_TF         =  5;
  ERROR_FPGA_ID	         =  6;
  ERROR_FPGA_CFG         =  7;
  ERROR_FPGA_IP          =  8;
  ERROR_FLASH_ID         =  9;
  ERROR_FLASH_CFG        = 10;

  ERROR_CHIPTYPE         = 20;
  ERROR_PROGID           = 21;
  ERROR_COUNTER          = 22;
  ERROR_AES              = 23;
  ERROR_CHKSUM           = 24;

  PROG_NULL              = 31;
  PROG_WAIT_KEY          = 32;
  PROG_AUTO              = 33;
  PROG_TEST_PIN          = 34;
  PROG_CONNECT           = 35;
  PROG_RESTORE           = 36;
  PROG_ERASE             = 37;
  PROG_WRITE             = 38;
  PROG_READ              = 39;
  PROG_VERIFY            = 40;
  PROG_PROTECT           = 41;
  PROG_UNPROTECT         = 42;
  PROG_BLANKCHECK        = 43;
  PROG_CTRL              = 44;
  PROG_EPROM             = 45;
  PROG_BOOTLOAD          = 46;
  PROG_ATE               = 47;
  PROG_SVF               = 48;
  PROG_IDCODE            = 49;
  PROG_CHECK_OPT         = 50;
  PROG_PIO               = 51;
  PROG_WRITE_OPT         = 52;
  PROG_READ_OPT          = 53;
  PROG_TEST              = 54;
  PROG_USER_ID0          = 55;
  PROG_USER_ID1          = 56;
  PROG_USER_ID2          = 57;
  PROG_EXECUTE           = 58;
  PROG_JMO_NO            = 59;
  PROG_DOWNLOAD          = 60;
  PROG_POWERON           = 61;
  PROG_POWEROFF          = 62;
  PROG_FINISH            = 63;

  ERROR_CONNECT          = 70;
  ERROR_PARAMETER        = 71;
  ERROR_FILE_NOT_FOUND   = 72;
  ERROR_READ_FILE        = 73;
  ERROR_WRITE_FILE       = 74;
  ERROR_TOO_MANY_COMMAND = 75;
  ERROR_UNKNOWN_COMMAND  = 76;
  ERROR_JMO_FILE         = 77;
  ERROR_JMO_DOWNLOAD     = 78;
  ERROR_UNKNOWN          = 79;

  MODE_MONITOR           = 80;
  MODE_PROGRAM           = 81;

const
  IC_24             = $00000001;

  IC_XMC1000        = $00000002;
  IC_XMC4000        = $00000003;
  IC_XMC1XSX        = $00000004;
  IC_XC800          = $00000005;
  IC_XMC4000S       = $00000006; // SWD
  IC_XC2000         = $00000007;
  IC_XMC4000W       = $00000008;
  IC_XC800W         = $00000009;
  IC_TLE984X        = $0000000A; // LIN
  IC_TLE986X7X      = $0000000B; // LIN
  IC_TLE98XX        = $0000000C; // SWD
  IC_TLE985X        = $0000000D; // LIN

  IC_ME             = $0000000E;
  IC_25             = $0000000F;

  IC_CORTEX_M       = $00000011;

  IC_STM32          = $00000021;
  IC_STM32I         = $00000022;  // ISP
  IC_STM32W         = $00000023;  // WISP

  IC_ICSP8          = $00000028;  // Microchip PIC 8 bits CPU, PIC12F, 16F, 18F

  IC_NXPLPCM        = $00000031;
  IC_NXPLPCMI       = $00000032;  // ISP
  IC_NXPLPCMW       = $00000033;  // WISP

  IC_NUVOTON        = $00000041;
  IC_NUVOTONI       = $00000042;  // ISP
  IC_NUVOTONW       = $00000043;  // WISP

  IC_GD32           = $00000051;
  IC_GD32I          = $00000052;  // ISP
  IC_GD32W          = $00000053;  // WISP

  IC_MM32           = $00000061;
  IC_MM32I          = $00000062;  // ISP
  IC_MM32W          = $00000063;  // WISP

  IC_LKS32          = $00000071;
  IC_LKS32I         = $00000072;  // ISP
  IC_LKS32W         = $00000073;  // WISP

  IC_AT89LP         = $00000081;
  IC_AT89LPI        = $00000082;  // ISP
  IC_AT89LPW        = $00000083;  // WISP

  IC_TMS320F        = $00000091;  // UART
  IC_TMS320FI       = $00000092;  // ISP
  IC_TMS320FW       = $00000093;  // WISP

  IC_RENESAS_RX200  = $000000A1;  // FINE
  IC_RENESAS_RX200I = $000000A2;  // SCI
  IC_RENESAS_RX200W = $000000A3;  // WSCI

  IC_JTAG_SVF       = $00000800;

  IC_USERDEF        = $0000FFFF;

implementation

end.
