
#define RUN0             0xFC
#define RUN1             0xFD
#define RUN2             0xFE
#define RUNALL           0xFF

#define CMD_CONNECT      0x01
#define CMD_DISCONNECT   0x02
#define CMD_MESSAGE      0x03
#define CMD_RUN          0x04
#define CMD_FILE         0x05
#define CMD_STATUS       0x06
#define CMD_RESET        0x07
#define CMD_POWER        0x08
#define CMD_AUTOFILE     0x09
#define CMD_DOWNLOAD     0x0A
#define CMD_PASSWORD     0x0B
#define CMD_NAME         0x0C

#define CMD_SERIAL_CLR_1 0x11
#define CMD_SERIAL_CLR_2 0x12
#define CMD_SERIAL_CLR_A 0x13
#define CMD_SERIAL_ADR_1 0x15
#define CMD_SERIAL_ADR_2 0x16
#define CMD_SERIAL_ADR_A 0x17
#define CMD_SERIAL_DAT_1 0x19
#define CMD_SERIAL_DAT_2 0x1A
#define CMD_SERIAL_DAT_A 0x1B

#define CMD_WRITEIO      0xC0
#define CMD_READIO       0xE0

#define RES_MESSAGE      0x01
#define RES_READDATA     0x02
#define RES_WRITELOG     0x03
#define RES_WRITELOGHEAD 0x04
#define RES_READFUNC     0x05
#define RES_STATUS       0x06
#define RES_INTERROR     0x07
#define RES_VERSION      0x08
#define RES_FILE         0x09
#define RES_IO           0x0A

#define RES_COMERR       0xFA
#define RES_OK           0xFB
#define RES_ERROR        0xFC
#define RES_MODE         0xFD
#define RES_CHKSUM       0xFE
#define RES_UNKNOWN      0xFF

typedef unsigned char u8 ;
typedef unsigned long u32;

//typedef __packed struct {	// 	ARM32 CPU,  __packed
typedef struct {
  u8  JM        ;   // J.Master ͺ       3: JM3
  u8  MVER      ;   // 汾
  u8  SVER      ;   // ظ汾
  u8  LCD       ;   // ǷLCDʾ       0: ûLCDʾ        ǣLCDʾ
  u8  TF        ;   // TF ״̬                 0: ûTFTF ǣTF
  u8  FNUM      ;   // FLASHTFеJMOļ
  u8  MODE      ;   // ǰ״̬        0: ̬             ǣ̬
  u32 PSNO      ;   // 
  u8  NAME[20]  ;   // 
  u8  AUTOFT    ;   // ļ          1: FLASH    2: TF 
  u8  AUTOFN[13];   // ļ
  u8  ATE1      ;   // ̿P1 ATE ״ֵ̬:   λ0: BUSY   λ1: OK   λ2: NG   λ3: START
  u8  ATE2      ;   // ̿P1 ATE ״ֵ̬:   λ0: BUSY   λ1: OK   λ2: NG   λ3: START
  u8  ATEM      ;   // ATE Чƽ:   λ0: BUSY   λ1: OK   λ2: NG   λ3: START   0: ߵƽЧ   1: ͵ƽЧ
  u32 CCNT      ;   // ǰʣֵ̼
  u8  IODATA    ;   // IO˿
  u8  SNO       ;   // JMO ļд            0: д           ǣд
  u8  AES       ;   // JMO ļû          0: ûû       ǣû
  u8  PID       ;   // JMO ļ޶      0: û޶   0б޶
  u8  START     ;   // JMO ļʽ      1:      2: ԶоƬ    3: Զ̻
  u32 PCNT      ;   // JMO ļıֵ̼
  u32 CHKSUM    ;   // JMO ļ HEX У
  u32 ICTYPE    ;   // JMO ļоƬ
  u8  FDESC[20] ;   // JMO ļ
  u8  FT        ;   // ļ    1: FLASH    2: TF 
  u8  FN[13]    ;   // ļ
  u8  ERRNO     ;   // 
  u8  ERR       ;   // ־                  0: ûд           0д
  u8  UPDATE    ;   // ״̬仯              0ûб仯           0б仯
  u8  BAR       ;   //    0..20
  u8  PNO       ;   // ̶˿    0: ˿P1    1: ˿P2
  u32 PSTATUS   ;   // ״̬
} JM_COM_TYPE;

#define IC_24         0x00000001

#define IC_XMC1000    0x00000002
#define IC_XMC4000    0x00000003
#define IC_XMC1XSX    0x00000004
#define IC_XC800      0x00000005
#define IC_XMC4000S   0x00000006 /* SWD  */
#define IC_XMC1000W   0x00000007
#define IC_XMC4000W   0x00000008
#define IC_XC800W     0x00000009
#define IC_TLE984X    0x0000000A /* LIN  */
#define IC_TLE986X7X  0x0000000B /* LIN  */
#define IC_TLE98XX    0x0000000C /* SWD	 */

#define IC_ME         0x0000000E
#define IC_25         0x0000000F

#define IC_CORTEX_M   0x00000011

#define IC_STM32      0x00000021
#define IC_STM32I     0x00000022  /* ISP  */
#define IC_STM32W     0x00000023  /* WISP */

#define IC_NXPLPCM    0x00000031
#define IC_NXPLPCMI   0x00000032  /* ISP  */
#define IC_NXPLPCMW   0x00000033  /* WISP */

#define IC_NUVOTON    0x00000041
#define IC_NUVOTONI   0x00000042  /* ISP  */
#define IC_NUVOTONW   0x00000043  /* WISP */

#define IC_AT89LP     0x00000081
#define IC_AT89LPI    0x00000082  /* ISP  */
#define IC_AT89LPW    0x00000083  /* WISP */

#define IC_JTAG_SVF   0x00000800

// ״̬ Status
#define bPGNull       0x00000000
#define bPGWaitKey    0x00000001
#define bPGAuto       0x00000002
#define bPGTestPIN    0x00000004
#define bPGConnect    0x00000008
#define bPGRestore    0x00000010
#define bPGErase      0x00000020
#define bPGWrite      0x00000040
#define bPGRead       0x00000080
#define bPGVerify     0x00000100
#define bPGProtect    0x00000200
#define bPGUnProtect  0x00000400
#define bPGBlankCheck 0x00000800
#define bPGCTRL       0x00001000
#define bPGEPROM      0x00002000
#define bPGBootLoad   0x00004000
#define bPGATE        0x00008000

//// SVF
#define bPGSVF        0x00010000
#define bPGIDCODE     0x00020000
#define bPGCheckOPT   0x00040000
#define bPGPIO        0x00080000
#define bPGWriteOPT   0x00100000
#define bPGReadOPT    0x00200000
#define bPGTEST       0x00400000
#define bPGUserID1    0x00800000
#define bPGUserID2    0x01000000
#define bPGUserID3    0x02000000

#define bPGExecute    0x04000000
#define bPGJMONo      0x08000000
#define bPGDownload   0x10000000
#define bPGPowerOn    0x20000000
#define bPGPowerOff   0x40000000
#define bPGFinish     0x80000000

// Internal Error
#define MONI_ERROR           1   /* ش       */
#define ALGO_ERROR           2	 /* 㷨       */
#define RTC_ERROR            3	 /* ʵʱʱӴ   */
#define FLASH_FORMAT_ERROR   4	 /* FLASH ʽ */
#define FLASH_TF_ERROR       5	 /* TF       */
#define FPGA_ID_ERROR	     6	 /* FPGA ʶ  */
#define FPGA_CFG_ERROR       7	 /* FPGA ̴  */
#define FPGA_IP_ERROR        8	 /* FPGA IP    */
#define FLASH_ID_ERROR       9	 /* FLASH ʶ */
#define FLASH_CFG_ERROR     10	 /* FLASH ô */

#define EXEC_IC             20	 /* оƬ֧     */
#define EXEC_PROGID         21	 /* ̱Ų֧ */
#define EXEC_COUNTER        22	 /* ̼Ϊ 0   */
#define EXEC_AES            23	 /*        */
#define EXEC_CHKSUM         24	 /* Уʹ     */

// ͬ C 汾 DLL ĸʽǲһģ밴ӦҪдһģøģcdeclʽ
u32 JM_INIT      (u32 U, u8 * p)              ;
u32 JM_CONNECT   ()                           ;
u32 JM_DISCONNECT()                           ;
u32 JM_MESSAGE   ()                           ;
u32 JM_RUN       (u32 RUN)                    ;
u32 JM_FILE      (u32 N)                      ;
u32 JM_STATUS    ()                           ;
u32 JM_RESET     ()                           ;
u32 JM_POWER     (u32 P)                      ;
u32 JM_WRITEIO   (u32 A, u32 D)               ;
u32 JM_READIO    (u32 A)                      ;
u32 JM_AUTOFILE  (u32 u32)                    ;
u32 JM_DOWNLOAD  (u32 F, u8 * p)              ;
u32 JM_DELETE    (u32 N)                      ;
u32 JM_PASSWORD  (u8 * p)                     ;
u32 JM_NAME      (u8 * p)                     ;
u32 JM_SERIAL_CLR(u32 c)                      ;
u32 JM_SERIAL_SET(u32 c, u32 A, u32 L, u8 * p);
