
#include "JM_COM.H"
#include "REG52.H"

u8 ReadBuf[64];
u8 COMErr;
u8 RES;

idata JM_COM_TYPE JMVAR;

void InitUART()
{
  COMErr = 0;
  RES    = RES_OK;

  SCON   = 0x50;
  RCAP2H = 0xFF;
  RCAP2L = 0xFD;
  TH2    = 0xFF;
  TL2    = 0xFD;
  T2CON  = 0x34;
  TR2    = 1   ;
}

void WriteUART(u8 D)
{
  if (COMErr) return;

  SBUF = D;

  while (TI == 0) ;  // wait send finish
  TI = 0;
}

u8 ReadUART()
{
  if (COMErr) return(0);

  while (RI == 0) ;  // wait data received

  RI = 0;
  return(SBUF);

}

u8 ReadAnswer()
{
  u8 i, l, s;

  if (COMErr) return(RES_COMERR);

  if (ReadUART() != 0xAA) {
    COMErr = 1;
    return(RES_COMERR);
  }

  ReadBuf[0] = 0xAA;
  ReadBuf[1] = ReadUART();

  l = ReadBuf[1];
  if ( (l == 0) || (l > 62) ) {
    COMErr = 1;
    return(RES_COMERR);
  }

  for (i=0; i<l; i++) ReadBuf[i+2] = ReadUART();

  s = 0;
  for (i=0; i<(l+2); i++) s += ReadBuf[i];

  if (s) {
    COMErr = 1;
    return(RES_COMERR);
  }

  return(ReadBuf[2]);
}

u8 JM_CMD(u8 CMD, u8 DAT)
{
  u8 s;

  s = 0x55 + CMD + DAT;
  s = ~s + 1;

  WriteUART(0x55);
  WriteUART(CMD );
  WriteUART(DAT );
  WriteUART(s   );

  return(ReadAnswer());
}

u8 JM_CONNECT(void)
{
  u8 i;

  InitUART();

  RES = JM_CMD(CMD_CONNECT, 0);

  if (RES != RES_VERSION) return(RES);

  JMVAR.JM   = ReadBuf[3];
  JMVAR.MVER = ReadBuf[4];
  JMVAR.SVER = ReadBuf[5];
  JMVAR.LCD  = ReadBuf[6];
  JMVAR.TF   = ReadBuf[7];
  JMVAR.FNUM = ReadBuf[8];
  JMVAR.MODE = ReadBuf[9];
  JMVAR.PSNO = ReadBuf[10] + (ReadBuf[11] << 8) + (ReadBuf[12] << 16) + (ReadBuf[13] << 24);

  // NAME
  for (i=0; i<20; i++) JMVAR.NAME[i] = ReadBuf[14+i];

  // AUTO FILE
  JMVAR.AUTOFT = ReadBuf[34];
  for (i=0; i<13; i++) JMVAR.AUTOFN[i] = ReadBuf[35+i];

  MonitorMode();

  return(RES_VERSION);
}

u8 JM_DISCONNECT(void)
{
  MonitorMode();

  return(JM_CMD(CMD_DISCONNECT, 0));
}

u8 JM_STATUS(void)
{
  RES = JM_CMD(CMD_STATUS, 0);

  if (RES != RES_STATUS) return(RES);

  JMVAR.MODE = ReadBuf[3];
  JMVAR.ATE1 = ReadBuf[4];
  JMVAR.ATE2 = ReadBuf[5];
  JMVAR.CCNT = ReadBuf[6] + (ReadBuf[7] << 8) + (ReadBuf[8] << 16) + (ReadBuf[9] << 24);
  return(RES);
}

u8 JM_MESSAGE(void)
{
  RES = JM_CMD(CMD_MESSAGE, 0);

  if (RES == RES_MESSAGE) {
    JMVAR.ERR     = ReadBuf[3];
    JMVAR.UPDATE  = (ReadBuf[4] >> 7) & 1;
    JMVAR.BAR     = ReadBuf[5];
    JMVAR.PNO     = ReadBuf[6];
    JMVAR.PSTATUS = ReadBuf[7] + (ReadBuf[8] << 8) + (ReadBuf[9] << 16) + (ReadBuf[10] << 24);
    if (ReadBuf[6] == 0) JMVAR.ATE1 = ReadBuf[4] & 0x0F; else JMVAR.ATE2 = ReadBuf[4] & 0x0F;
  } else if (RES == RES_READDATA) {
    ;
  } else if (RES == RES_WRITELOG) {
    ;
  } else if (RES == RES_WRITELOGHEAD) {
    ;
  } else if (RES == RES_READFUNC) {  // Read function
    ;
  } else if (RES == RES_STATUS) {  // Status
    JMVAR.MODE = ReadBuf[3];
    JMVAR.ATE1 = ReadBuf[4];
    JMVAR.ATE2 = ReadBuf[5];
    JMVAR.CCNT = ReadBuf[6] + (ReadBuf[7] << 8) + (ReadBuf[8] << 16) + (ReadBuf[9] << 24);
  } else if (RES == RES_INTERROR) {
    JMVAR.ERRNO = ReadBuf[3];
  }
  return(RES);

}

u8 JM_RUN(u8 F)
{
  RES = JM_STATUS();

  if (RES != RES_STATUS) return(RES);

  if (F < RUN0) {
    if (JMVAR.MODE != 0) return(RES_MODE);
    if ( (F > JMVAR.FNUM) || (F == 0) ) return(RES_ERROR);

    RES = JM_CMD(CMD_RUN, F);
    Wait100ms(20);               // wait 2000ms for JM3 check JMO file
    return(WaitStatus(100, 1));  // wait 10 second for MODE = 1
  } else if (F == RUN0) {
    if (JMVAR.MODE == 0) return(RES_MODE);
    RES = JM_CMD(CMD_RUN, F);
    return(WaitStatus(20, 0));   // wait 2 second for MODE = 0
  } else if ( (F == RUN1) || (F == RUN2) || (F == RUNALL) ) {
    if (JMVAR.MODE == 0) return(RES_MODE);
    return(JM_CMD(CMD_RUN, F));
  } else return(RES_ERROR);
}

u8 JM_FILE(u8 F)
{
  u8 i;

  RES = JM_CMD(CMD_FILE, F);

  JMVAR.SNO    = ReadBuf[3];
  JMVAR.AES    = ReadBuf[4];
  JMVAR.PID    = ReadBuf[5];
  JMVAR.ATEM   = ReadBuf[6];
  JMVAR.START  = ReadBuf[7];
  JMVAR.PCNT   = ReadBuf[ 8] + (ReadBuf[ 9] << 8) + (ReadBuf[10] << 16) + (ReadBuf[11] << 24);
  JMVAR.CHKSUM = ReadBuf[12] + (ReadBuf[13] << 8) + (ReadBuf[14] << 16) + (ReadBuf[15] << 24);
  JMVAR.ICTYPE = ReadBuf[16] + (ReadBuf[17] << 8) + (ReadBuf[18] << 16) + (ReadBuf[19] << 24);

  // FDESC
  for (i=0; i<20; i++) JMVAR.FDESC[i] = ReadBuf[20+i];

  // FT, FN
  JMVAR.FT = ReadBuf[40];
  for (i=0; i<13; i++) JMVAR.FN[i] = ReadBuf[41+i];

  return(RES);

}

u8 JM_RESET(void)
{
  return(JM_CMD(CMD_RESET, 0));
}

u8 JM_POWER(u8 P)
{
  return(JM_CMD(CMD_POWER, P));
}

u8 JM_WRITEIO(u8 A, u8 D)
{
  return(JM_CMD(CMD_WRITEIO | (A & 0x1F), D));
}

u8 JM_READIO(u8 A)
{
  return(JM_CMD(CMD_READIO | (A & 0x1F), 0));
}

u8 JM_AUTOFILE(u8 F)
{
  return(JM_CMD(CMD_AUTOFILE, F));
}

u8 JM_SERIAL_CLR(u8 C)
{
  RES = JM_STATUS();
  if (RES != RES_STATUS) return(RES);
  if (JMVAR.MODE == 0) return(RES_MODE);

  return(JM_CMD(C, 0));
}

u8 JM_SERIAL_ADR(u8 C, u8 A)
{ 
  RES = JM_STATUS();
  if (RES != RES_STATUS) return(RES);
  if (JMVAR.MODE == 0) return(RES_MODE);

  return(JM_CMD(C, A));
}

u8 JM_SERIAL_DAT(u8 C, u8 D)
{ 
  RES = JM_STATUS();
  if (RES != RES_STATUS) return(RES);
  if (JMVAR.MODE == 0) return(RES_MODE);

  return(JM_CMD(C, D));
}

void MonitorMode()
{
  u8 TryTimes;

  RES = JM_STATUS();
  if ( (JMVAR.MODE != 0) && (RES != RES_COMERR) ) {
    RES = JM_RUN(RUN0);
    TryTimes = 20;
    do {
      Wait100ms(1);
      TryTimes--;
      RES = JM_STATUS();
    } while ( (JMVAR.MODE != 0) && (TryTimes != 0) && (RES != RES_COMERR) );  // wait task finish or COMERR or TimeOut
    Wait100ms(1);
  }
}

u8 WaitStatus(u8 C, u8 S)  // C * 100ms
{
  u8 TryTimes;

  TryTimes = C;

  RES = JM_STATUS();
  while ( (JMVAR.MODE != S) && (TryTimes) && (RES != RES_COMERR) ) {
    Wait100ms(1);
    RES = JM_MESSAGE();
    if (RES == RES_INTERROR) return(RES_INTERROR);
    TryTimes--;
    RES = JM_STATUS();
  }
  Wait100ms(1);
  return(RES);
}

void Wait100ms(u8 T)
{
  u8  j;
  u32 i;

  for (j=0; j<T; j++)
    for (i=0; i<2000; i++) ;

}
